/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidationSeverity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValidationMessage
implements ToCopyableBuilder<Builder, ValidationMessage> {
    private final String message;
    private final String severity;
    private final String namespace;
    private final String optionName;

    private ValidationMessage(BuilderImpl builder) {
        this.message = builder.message;
        this.severity = builder.severity;
        this.namespace = builder.namespace;
        this.optionName = builder.optionName;
    }

    public String message() {
        return this.message;
    }

    public ValidationSeverity severity() {
        return ValidationSeverity.fromValue(this.severity);
    }

    public String severityString() {
        return this.severity;
    }

    public String namespace() {
        return this.namespace;
    }

    public String optionName() {
        return this.optionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationMessage)) {
            return false;
        }
        ValidationMessage other = (ValidationMessage)obj;
        return Objects.equals(this.message(), other.message()) && Objects.equals(this.severityString(), other.severityString()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.optionName(), other.optionName());
    }

    public String toString() {
        return ToString.builder((String)"ValidationMessage").add("Message", (Object)this.message()).add("Severity", (Object)this.severityString()).add("Namespace", (Object)this.namespace()).add("OptionName", (Object)this.optionName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "Severity": {
                return Optional.of(clazz.cast(this.severityString()));
            }
            case "Namespace": {
                return Optional.of(clazz.cast(this.namespace()));
            }
            case "OptionName": {
                return Optional.of(clazz.cast(this.optionName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String message;
        private String severity;
        private String namespace;
        private String optionName;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationMessage model) {
            this.message(model.message);
            this.severity(model.severity);
            this.namespace(model.namespace);
            this.optionName(model.optionName);
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ValidationSeverity severity) {
            this.severity(severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getOptionName() {
            return this.optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        public ValidationMessage build() {
            return new ValidationMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValidationMessage> {
        public Builder message(String var1);

        public Builder severity(String var1);

        public Builder severity(ValidationSeverity var1);

        public Builder namespace(String var1);

        public Builder optionName(String var1);
    }
}

