/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.Tag;
import software.amazon.awssdk.services.elasticbeanstalk.model.TagKeyListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateTagsForResourceRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, UpdateTagsForResourceRequest> {
    private final String resourceArn;
    private final List<Tag> tagsToAdd;
    private final List<String> tagsToRemove;

    private UpdateTagsForResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.tagsToAdd = builder.tagsToAdd;
        this.tagsToRemove = builder.tagsToRemove;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public List<Tag> tagsToAdd() {
        return this.tagsToAdd;
    }

    public List<String> tagsToRemove() {
        return this.tagsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagsToAdd());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagsToRemove());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTagsForResourceRequest)) {
            return false;
        }
        UpdateTagsForResourceRequest other = (UpdateTagsForResourceRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.tagsToAdd(), other.tagsToAdd()) && Objects.equals(this.tagsToRemove(), other.tagsToRemove());
    }

    public String toString() {
        return ToString.builder((String)"UpdateTagsForResourceRequest").add("ResourceArn", (Object)this.resourceArn()).add("TagsToAdd", this.tagsToAdd()).add("TagsToRemove", this.tagsToRemove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.of(clazz.cast(this.resourceArn()));
            }
            case "TagsToAdd": {
                return Optional.of(clazz.cast(this.tagsToAdd()));
            }
            case "TagsToRemove": {
                return Optional.of(clazz.cast(this.tagsToRemove()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private List<Tag> tagsToAdd;
        private List<String> tagsToRemove;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTagsForResourceRequest model) {
            this.resourceArn(model.resourceArn);
            this.tagsToAdd(model.tagsToAdd);
            this.tagsToRemove(model.tagsToRemove);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<Tag.Builder> getTagsToAdd() {
            return this.tagsToAdd != null ? (Collection)this.tagsToAdd.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagsToAdd(Collection<Tag> tagsToAdd) {
            this.tagsToAdd = TagListCopier.copy(tagsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToAdd(Tag ... tagsToAdd) {
            this.tagsToAdd(Arrays.asList(tagsToAdd));
            return this;
        }

        public final void setTagsToAdd(Collection<Tag.BuilderImpl> tagsToAdd) {
            this.tagsToAdd = TagListCopier.copyFromBuilder(tagsToAdd);
        }

        public final Collection<String> getTagsToRemove() {
            return this.tagsToRemove;
        }

        @Override
        public final Builder tagsToRemove(Collection<String> tagsToRemove) {
            this.tagsToRemove = TagKeyListCopier.copy(tagsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToRemove(String ... tagsToRemove) {
            this.tagsToRemove(Arrays.asList(tagsToRemove));
            return this;
        }

        public final void setTagsToRemove(Collection<String> tagsToRemove) {
            this.tagsToRemove = TagKeyListCopier.copy(tagsToRemove);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateTagsForResourceRequest build() {
            return new UpdateTagsForResourceRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, UpdateTagsForResourceRequest> {
        public Builder resourceArn(String var1);

        public Builder tagsToAdd(Collection<Tag> var1);

        public Builder tagsToAdd(Tag ... var1);

        public Builder tagsToRemove(Collection<String> var1);

        public Builder tagsToRemove(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

