/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceRepository;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SourceBuildInformation
implements ToCopyableBuilder<Builder, SourceBuildInformation> {
    private final String sourceType;
    private final String sourceRepository;
    private final String sourceLocation;

    private SourceBuildInformation(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.sourceRepository = builder.sourceRepository;
        this.sourceLocation = builder.sourceLocation;
    }

    public SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public String sourceTypeString() {
        return this.sourceType;
    }

    public SourceRepository sourceRepository() {
        return SourceRepository.fromValue(this.sourceRepository);
    }

    public String sourceRepositoryString() {
        return this.sourceRepository;
    }

    public String sourceLocation() {
        return this.sourceLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRepositoryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceBuildInformation)) {
            return false;
        }
        SourceBuildInformation other = (SourceBuildInformation)obj;
        return Objects.equals(this.sourceTypeString(), other.sourceTypeString()) && Objects.equals(this.sourceRepositoryString(), other.sourceRepositoryString()) && Objects.equals(this.sourceLocation(), other.sourceLocation());
    }

    public String toString() {
        return ToString.builder((String)"SourceBuildInformation").add("SourceType", (Object)this.sourceTypeString()).add("SourceRepository", (Object)this.sourceRepositoryString()).add("SourceLocation", (Object)this.sourceLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceType": {
                return Optional.of(clazz.cast(this.sourceTypeString()));
            }
            case "SourceRepository": {
                return Optional.of(clazz.cast(this.sourceRepositoryString()));
            }
            case "SourceLocation": {
                return Optional.of(clazz.cast(this.sourceLocation()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private String sourceRepository;
        private String sourceLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceBuildInformation model) {
            this.sourceType(model.sourceType);
            this.sourceRepository(model.sourceRepository);
            this.sourceLocation(model.sourceLocation);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getSourceRepository() {
            return this.sourceRepository;
        }

        @Override
        public final Builder sourceRepository(String sourceRepository) {
            this.sourceRepository = sourceRepository;
            return this;
        }

        @Override
        public final Builder sourceRepository(SourceRepository sourceRepository) {
            this.sourceRepository(sourceRepository.toString());
            return this;
        }

        public final void setSourceRepository(String sourceRepository) {
            this.sourceRepository = sourceRepository;
        }

        public final String getSourceLocation() {
            return this.sourceLocation;
        }

        @Override
        public final Builder sourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public final void setSourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        public SourceBuildInformation build() {
            return new SourceBuildInformation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SourceBuildInformation> {
        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder sourceRepository(String var1);

        public Builder sourceRepository(SourceRepository var1);

        public Builder sourceLocation(String var1);
    }
}

