/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.SupportedAddonListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.SupportedTierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PlatformSummary
implements ToCopyableBuilder<Builder, PlatformSummary> {
    private final String platformArn;
    private final String platformOwner;
    private final String platformStatus;
    private final String platformCategory;
    private final String operatingSystemName;
    private final String operatingSystemVersion;
    private final List<String> supportedTierList;
    private final List<String> supportedAddonList;

    private PlatformSummary(BuilderImpl builder) {
        this.platformArn = builder.platformArn;
        this.platformOwner = builder.platformOwner;
        this.platformStatus = builder.platformStatus;
        this.platformCategory = builder.platformCategory;
        this.operatingSystemName = builder.operatingSystemName;
        this.operatingSystemVersion = builder.operatingSystemVersion;
        this.supportedTierList = builder.supportedTierList;
        this.supportedAddonList = builder.supportedAddonList;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public String platformOwner() {
        return this.platformOwner;
    }

    public PlatformStatus platformStatus() {
        return PlatformStatus.fromValue(this.platformStatus);
    }

    public String platformStatusString() {
        return this.platformStatus;
    }

    public String platformCategory() {
        return this.platformCategory;
    }

    public String operatingSystemName() {
        return this.operatingSystemName;
    }

    public String operatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public List<String> supportedTierList() {
        return this.supportedTierList;
    }

    public List<String> supportedAddonList() {
        return this.supportedAddonList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformCategory());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedTierList());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedAddonList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformSummary)) {
            return false;
        }
        PlatformSummary other = (PlatformSummary)obj;
        return Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.platformOwner(), other.platformOwner()) && Objects.equals(this.platformStatusString(), other.platformStatusString()) && Objects.equals(this.platformCategory(), other.platformCategory()) && Objects.equals(this.operatingSystemName(), other.operatingSystemName()) && Objects.equals(this.operatingSystemVersion(), other.operatingSystemVersion()) && Objects.equals(this.supportedTierList(), other.supportedTierList()) && Objects.equals(this.supportedAddonList(), other.supportedAddonList());
    }

    public String toString() {
        return ToString.builder((String)"PlatformSummary").add("PlatformArn", (Object)this.platformArn()).add("PlatformOwner", (Object)this.platformOwner()).add("PlatformStatus", (Object)this.platformStatusString()).add("PlatformCategory", (Object)this.platformCategory()).add("OperatingSystemName", (Object)this.operatingSystemName()).add("OperatingSystemVersion", (Object)this.operatingSystemVersion()).add("SupportedTierList", this.supportedTierList()).add("SupportedAddonList", this.supportedAddonList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformArn": {
                return Optional.of(clazz.cast(this.platformArn()));
            }
            case "PlatformOwner": {
                return Optional.of(clazz.cast(this.platformOwner()));
            }
            case "PlatformStatus": {
                return Optional.of(clazz.cast(this.platformStatusString()));
            }
            case "PlatformCategory": {
                return Optional.of(clazz.cast(this.platformCategory()));
            }
            case "OperatingSystemName": {
                return Optional.of(clazz.cast(this.operatingSystemName()));
            }
            case "OperatingSystemVersion": {
                return Optional.of(clazz.cast(this.operatingSystemVersion()));
            }
            case "SupportedTierList": {
                return Optional.of(clazz.cast(this.supportedTierList()));
            }
            case "SupportedAddonList": {
                return Optional.of(clazz.cast(this.supportedAddonList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String platformArn;
        private String platformOwner;
        private String platformStatus;
        private String platformCategory;
        private String operatingSystemName;
        private String operatingSystemVersion;
        private List<String> supportedTierList;
        private List<String> supportedAddonList;

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformSummary model) {
            this.platformArn(model.platformArn);
            this.platformOwner(model.platformOwner);
            this.platformStatus(model.platformStatus);
            this.platformCategory(model.platformCategory);
            this.operatingSystemName(model.operatingSystemName);
            this.operatingSystemVersion(model.operatingSystemVersion);
            this.supportedTierList(model.supportedTierList);
            this.supportedAddonList(model.supportedAddonList);
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getPlatformOwner() {
            return this.platformOwner;
        }

        @Override
        public final Builder platformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
            return this;
        }

        public final void setPlatformOwner(String platformOwner) {
            this.platformOwner = platformOwner;
        }

        public final String getPlatformStatus() {
            return this.platformStatus;
        }

        @Override
        public final Builder platformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
            return this;
        }

        @Override
        public final Builder platformStatus(PlatformStatus platformStatus) {
            this.platformStatus(platformStatus.toString());
            return this;
        }

        public final void setPlatformStatus(String platformStatus) {
            this.platformStatus = platformStatus;
        }

        public final String getPlatformCategory() {
            return this.platformCategory;
        }

        @Override
        public final Builder platformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
            return this;
        }

        public final void setPlatformCategory(String platformCategory) {
            this.platformCategory = platformCategory;
        }

        public final String getOperatingSystemName() {
            return this.operatingSystemName;
        }

        @Override
        public final Builder operatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
            return this;
        }

        public final void setOperatingSystemName(String operatingSystemName) {
            this.operatingSystemName = operatingSystemName;
        }

        public final String getOperatingSystemVersion() {
            return this.operatingSystemVersion;
        }

        @Override
        public final Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            return this;
        }

        public final void setOperatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
        }

        public final Collection<String> getSupportedTierList() {
            return this.supportedTierList;
        }

        @Override
        public final Builder supportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTierList(String ... supportedTierList) {
            this.supportedTierList(Arrays.asList(supportedTierList));
            return this;
        }

        public final void setSupportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
        }

        public final Collection<String> getSupportedAddonList() {
            return this.supportedAddonList;
        }

        @Override
        public final Builder supportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedAddonList(String ... supportedAddonList) {
            this.supportedAddonList(Arrays.asList(supportedAddonList));
            return this;
        }

        public final void setSupportedAddonList(Collection<String> supportedAddonList) {
            this.supportedAddonList = SupportedAddonListCopier.copy(supportedAddonList);
        }

        public PlatformSummary build() {
            return new PlatformSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PlatformSummary> {
        public Builder platformArn(String var1);

        public Builder platformOwner(String var1);

        public Builder platformStatus(String var1);

        public Builder platformStatus(PlatformStatus var1);

        public Builder platformCategory(String var1);

        public Builder operatingSystemName(String var1);

        public Builder operatingSystemVersion(String var1);

        public Builder supportedTierList(Collection<String> var1);

        public Builder supportedTierList(String ... var1);

        public Builder supportedAddonList(Collection<String> var1);

        public Builder supportedAddonList(String ... var1);
    }
}

