/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticbeanstalk.model.AutoScalingGroup;
import software.amazon.awssdk.services.elasticbeanstalk.model.AutoScalingGroupListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.Instance;
import software.amazon.awssdk.services.elasticbeanstalk.model.InstanceListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.LaunchConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.LaunchConfigurationListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancer;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadBalancerListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.Queue;
import software.amazon.awssdk.services.elasticbeanstalk.model.QueueListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.Trigger;
import software.amazon.awssdk.services.elasticbeanstalk.model.TriggerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnvironmentResourceDescription
implements ToCopyableBuilder<Builder, EnvironmentResourceDescription> {
    private final String environmentName;
    private final List<AutoScalingGroup> autoScalingGroups;
    private final List<Instance> instances;
    private final List<LaunchConfiguration> launchConfigurations;
    private final List<LoadBalancer> loadBalancers;
    private final List<Trigger> triggers;
    private final List<Queue> queues;

    private EnvironmentResourceDescription(BuilderImpl builder) {
        this.environmentName = builder.environmentName;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.instances = builder.instances;
        this.launchConfigurations = builder.launchConfigurations;
        this.loadBalancers = builder.loadBalancers;
        this.triggers = builder.triggers;
        this.queues = builder.queues;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public List<AutoScalingGroup> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public List<LaunchConfiguration> launchConfigurations() {
        return this.launchConfigurations;
    }

    public List<LoadBalancer> loadBalancers() {
        return this.loadBalancers;
    }

    public List<Trigger> triggers() {
        return this.triggers;
    }

    public List<Queue> queues() {
        return this.queues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancers());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggers());
        hashCode = 31 * hashCode + Objects.hashCode(this.queues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentResourceDescription)) {
            return false;
        }
        EnvironmentResourceDescription other = (EnvironmentResourceDescription)obj;
        return Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.autoScalingGroups(), other.autoScalingGroups()) && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.launchConfigurations(), other.launchConfigurations()) && Objects.equals(this.loadBalancers(), other.loadBalancers()) && Objects.equals(this.triggers(), other.triggers()) && Objects.equals(this.queues(), other.queues());
    }

    public String toString() {
        return ToString.builder((String)"EnvironmentResourceDescription").add("EnvironmentName", (Object)this.environmentName()).add("AutoScalingGroups", this.autoScalingGroups()).add("Instances", this.instances()).add("LaunchConfigurations", this.launchConfigurations()).add("LoadBalancers", this.loadBalancers()).add("Triggers", this.triggers()).add("Queues", this.queues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentName": {
                return Optional.of(clazz.cast(this.environmentName()));
            }
            case "AutoScalingGroups": {
                return Optional.of(clazz.cast(this.autoScalingGroups()));
            }
            case "Instances": {
                return Optional.of(clazz.cast(this.instances()));
            }
            case "LaunchConfigurations": {
                return Optional.of(clazz.cast(this.launchConfigurations()));
            }
            case "LoadBalancers": {
                return Optional.of(clazz.cast(this.loadBalancers()));
            }
            case "Triggers": {
                return Optional.of(clazz.cast(this.triggers()));
            }
            case "Queues": {
                return Optional.of(clazz.cast(this.queues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String environmentName;
        private List<AutoScalingGroup> autoScalingGroups;
        private List<Instance> instances;
        private List<LaunchConfiguration> launchConfigurations;
        private List<LoadBalancer> loadBalancers;
        private List<Trigger> triggers;
        private List<Queue> queues;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentResourceDescription model) {
            this.environmentName(model.environmentName);
            this.autoScalingGroups(model.autoScalingGroups);
            this.instances(model.instances);
            this.launchConfigurations(model.launchConfigurations);
            this.loadBalancers(model.loadBalancers);
            this.triggers(model.triggers);
            this.queues(model.queues);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final Collection<AutoScalingGroup.Builder> getAutoScalingGroups() {
            return this.autoScalingGroups != null ? (Collection)this.autoScalingGroups.stream().map(AutoScalingGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        public final void setAutoScalingGroups(Collection<AutoScalingGroup.BuilderImpl> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copyFromBuilder(autoScalingGroups);
        }

        public final Collection<Instance.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstanceListCopier.copyFromBuilder(instances);
        }

        public final Collection<LaunchConfiguration.Builder> getLaunchConfigurations() {
            return this.launchConfigurations != null ? (Collection)this.launchConfigurations.stream().map(LaunchConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationListCopier.copy(launchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurations(LaunchConfiguration ... launchConfigurations) {
            this.launchConfigurations(Arrays.asList(launchConfigurations));
            return this;
        }

        public final void setLaunchConfigurations(Collection<LaunchConfiguration.BuilderImpl> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationListCopier.copyFromBuilder(launchConfigurations);
        }

        public final Collection<LoadBalancer.Builder> getLoadBalancers() {
            return this.loadBalancers != null ? (Collection)this.loadBalancers.stream().map(LoadBalancer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancerListCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancerListCopier.copyFromBuilder(loadBalancers);
        }

        public final Collection<Trigger.Builder> getTriggers() {
            return this.triggers != null ? (Collection)this.triggers.stream().map(Trigger::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder triggers(Collection<Trigger> triggers) {
            this.triggers = TriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Trigger ... triggers) {
            this.triggers(Arrays.asList(triggers));
            return this;
        }

        public final void setTriggers(Collection<Trigger.BuilderImpl> triggers) {
            this.triggers = TriggerListCopier.copyFromBuilder(triggers);
        }

        public final Collection<Queue.Builder> getQueues() {
            return this.queues != null ? (Collection)this.queues.stream().map(Queue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queues(Collection<Queue> queues) {
            this.queues = QueueListCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(Queue ... queues) {
            this.queues(Arrays.asList(queues));
            return this;
        }

        public final void setQueues(Collection<Queue.BuilderImpl> queues) {
            this.queues = QueueListCopier.copyFromBuilder(queues);
        }

        public EnvironmentResourceDescription build() {
            return new EnvironmentResourceDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentResourceDescription> {
        public Builder environmentName(String var1);

        public Builder autoScalingGroups(Collection<AutoScalingGroup> var1);

        public Builder autoScalingGroups(AutoScalingGroup ... var1);

        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder launchConfigurations(Collection<LaunchConfiguration> var1);

        public Builder launchConfigurations(LaunchConfiguration ... var1);

        public Builder loadBalancers(Collection<LoadBalancer> var1);

        public Builder loadBalancers(LoadBalancer ... var1);

        public Builder triggers(Collection<Trigger> var1);

        public Builder triggers(Trigger ... var1);

        public Builder queues(Collection<Queue> var1);

        public Builder queues(Queue ... var1);
    }
}

