/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnvironmentInfoDescription
implements ToCopyableBuilder<Builder, EnvironmentInfoDescription> {
    private final String infoType;
    private final String ec2InstanceId;
    private final Instant sampleTimestamp;
    private final String message;

    private EnvironmentInfoDescription(BuilderImpl builder) {
        this.infoType = builder.infoType;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.sampleTimestamp = builder.sampleTimestamp;
        this.message = builder.message;
    }

    public EnvironmentInfoType infoType() {
        return EnvironmentInfoType.fromValue(this.infoType);
    }

    public String infoTypeString() {
        return this.infoType;
    }

    public String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public Instant sampleTimestamp() {
        return this.sampleTimestamp;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.infoTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentInfoDescription)) {
            return false;
        }
        EnvironmentInfoDescription other = (EnvironmentInfoDescription)obj;
        return Objects.equals(this.infoTypeString(), other.infoTypeString()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(this.sampleTimestamp(), other.sampleTimestamp()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        return ToString.builder((String)"EnvironmentInfoDescription").add("InfoType", (Object)this.infoTypeString()).add("Ec2InstanceId", (Object)this.ec2InstanceId()).add("SampleTimestamp", (Object)this.sampleTimestamp()).add("Message", (Object)this.message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InfoType": {
                return Optional.of(clazz.cast(this.infoTypeString()));
            }
            case "Ec2InstanceId": {
                return Optional.of(clazz.cast(this.ec2InstanceId()));
            }
            case "SampleTimestamp": {
                return Optional.of(clazz.cast(this.sampleTimestamp()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String infoType;
        private String ec2InstanceId;
        private Instant sampleTimestamp;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentInfoDescription model) {
            this.infoType(model.infoType);
            this.ec2InstanceId(model.ec2InstanceId);
            this.sampleTimestamp(model.sampleTimestamp);
            this.message(model.message);
        }

        public final String getInfoType() {
            return this.infoType;
        }

        @Override
        public final Builder infoType(String infoType) {
            this.infoType = infoType;
            return this;
        }

        @Override
        public final Builder infoType(EnvironmentInfoType infoType) {
            this.infoType(infoType.toString());
            return this;
        }

        public final void setInfoType(String infoType) {
            this.infoType = infoType;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final Instant getSampleTimestamp() {
            return this.sampleTimestamp;
        }

        @Override
        public final Builder sampleTimestamp(Instant sampleTimestamp) {
            this.sampleTimestamp = sampleTimestamp;
            return this;
        }

        public final void setSampleTimestamp(Instant sampleTimestamp) {
            this.sampleTimestamp = sampleTimestamp;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public EnvironmentInfoDescription build() {
            return new EnvironmentInfoDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentInfoDescription> {
        public Builder infoType(String var1);

        public Builder infoType(EnvironmentInfoType var1);

        public Builder ec2InstanceId(String var1);

        public Builder sampleTimestamp(Instant var1);

        public Builder message(String var1);
    }
}

