/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.BuildConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;
import software.amazon.awssdk.services.elasticbeanstalk.model.SourceBuildInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateApplicationVersionRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, CreateApplicationVersionRequest> {
    private final String applicationName;
    private final String versionLabel;
    private final String description;
    private final SourceBuildInformation sourceBuildInformation;
    private final S3Location sourceBundle;
    private final BuildConfiguration buildConfiguration;
    private final Boolean autoCreateApplication;
    private final Boolean process;

    private CreateApplicationVersionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.description = builder.description;
        this.sourceBuildInformation = builder.sourceBuildInformation;
        this.sourceBundle = builder.sourceBundle;
        this.buildConfiguration = builder.buildConfiguration;
        this.autoCreateApplication = builder.autoCreateApplication;
        this.process = builder.process;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public String description() {
        return this.description;
    }

    public SourceBuildInformation sourceBuildInformation() {
        return this.sourceBuildInformation;
    }

    public S3Location sourceBundle() {
        return this.sourceBundle;
    }

    public BuildConfiguration buildConfiguration() {
        return this.buildConfiguration;
    }

    public Boolean autoCreateApplication() {
        return this.autoCreateApplication;
    }

    public Boolean process() {
        return this.process;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBuildInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBundle());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoCreateApplication());
        hashCode = 31 * hashCode + Objects.hashCode(this.process());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationVersionRequest)) {
            return false;
        }
        CreateApplicationVersionRequest other = (CreateApplicationVersionRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sourceBuildInformation(), other.sourceBuildInformation()) && Objects.equals(this.sourceBundle(), other.sourceBundle()) && Objects.equals(this.buildConfiguration(), other.buildConfiguration()) && Objects.equals(this.autoCreateApplication(), other.autoCreateApplication()) && Objects.equals(this.process(), other.process());
    }

    public String toString() {
        return ToString.builder((String)"CreateApplicationVersionRequest").add("ApplicationName", (Object)this.applicationName()).add("VersionLabel", (Object)this.versionLabel()).add("Description", (Object)this.description()).add("SourceBuildInformation", (Object)this.sourceBuildInformation()).add("SourceBundle", (Object)this.sourceBundle()).add("BuildConfiguration", (Object)this.buildConfiguration()).add("AutoCreateApplication", (Object)this.autoCreateApplication()).add("Process", (Object)this.process()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "VersionLabel": {
                return Optional.of(clazz.cast(this.versionLabel()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "SourceBuildInformation": {
                return Optional.of(clazz.cast(this.sourceBuildInformation()));
            }
            case "SourceBundle": {
                return Optional.of(clazz.cast(this.sourceBundle()));
            }
            case "BuildConfiguration": {
                return Optional.of(clazz.cast(this.buildConfiguration()));
            }
            case "AutoCreateApplication": {
                return Optional.of(clazz.cast(this.autoCreateApplication()));
            }
            case "Process": {
                return Optional.of(clazz.cast(this.process()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String versionLabel;
        private String description;
        private SourceBuildInformation sourceBuildInformation;
        private S3Location sourceBundle;
        private BuildConfiguration buildConfiguration;
        private Boolean autoCreateApplication;
        private Boolean process;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationVersionRequest model) {
            this.applicationName(model.applicationName);
            this.versionLabel(model.versionLabel);
            this.description(model.description);
            this.sourceBuildInformation(model.sourceBuildInformation);
            this.sourceBundle(model.sourceBundle);
            this.buildConfiguration(model.buildConfiguration);
            this.autoCreateApplication(model.autoCreateApplication);
            this.process(model.process);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final SourceBuildInformation.Builder getSourceBuildInformation() {
            return this.sourceBuildInformation != null ? this.sourceBuildInformation.toBuilder() : null;
        }

        @Override
        public final Builder sourceBuildInformation(SourceBuildInformation sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation;
            return this;
        }

        public final void setSourceBuildInformation(SourceBuildInformation.BuilderImpl sourceBuildInformation) {
            this.sourceBuildInformation = sourceBuildInformation != null ? sourceBuildInformation.build() : null;
        }

        public final S3Location.Builder getSourceBundle() {
            return this.sourceBundle != null ? this.sourceBundle.toBuilder() : null;
        }

        @Override
        public final Builder sourceBundle(S3Location sourceBundle) {
            this.sourceBundle = sourceBundle;
            return this;
        }

        public final void setSourceBundle(S3Location.BuilderImpl sourceBundle) {
            this.sourceBundle = sourceBundle != null ? sourceBundle.build() : null;
        }

        public final BuildConfiguration.Builder getBuildConfiguration() {
            return this.buildConfiguration != null ? this.buildConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder buildConfiguration(BuildConfiguration buildConfiguration) {
            this.buildConfiguration = buildConfiguration;
            return this;
        }

        public final void setBuildConfiguration(BuildConfiguration.BuilderImpl buildConfiguration) {
            this.buildConfiguration = buildConfiguration != null ? buildConfiguration.build() : null;
        }

        public final Boolean getAutoCreateApplication() {
            return this.autoCreateApplication;
        }

        @Override
        public final Builder autoCreateApplication(Boolean autoCreateApplication) {
            this.autoCreateApplication = autoCreateApplication;
            return this;
        }

        public final void setAutoCreateApplication(Boolean autoCreateApplication) {
            this.autoCreateApplication = autoCreateApplication;
        }

        public final Boolean getProcess() {
            return this.process;
        }

        @Override
        public final Builder process(Boolean process) {
            this.process = process;
            return this;
        }

        public final void setProcess(Boolean process) {
            this.process = process;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationVersionRequest build() {
            return new CreateApplicationVersionRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, CreateApplicationVersionRequest> {
        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder description(String var1);

        public Builder sourceBuildInformation(SourceBuildInformation var1);

        default public Builder sourceBuildInformation(Consumer<SourceBuildInformation.Builder> sourceBuildInformation) {
            return this.sourceBuildInformation((SourceBuildInformation)((SourceBuildInformation.Builder)SourceBuildInformation.builder().apply(sourceBuildInformation)).build());
        }

        public Builder sourceBundle(S3Location var1);

        default public Builder sourceBundle(Consumer<S3Location.Builder> sourceBundle) {
            return this.sourceBundle((S3Location)((S3Location.Builder)S3Location.builder().apply(sourceBundle)).build());
        }

        public Builder buildConfiguration(BuildConfiguration var1);

        default public Builder buildConfiguration(Consumer<BuildConfiguration.Builder> buildConfiguration) {
            return this.buildConfiguration((BuildConfiguration)((BuildConfiguration.Builder)BuildConfiguration.builder().apply(buildConfiguration)).build());
        }

        public Builder autoCreateApplication(Boolean var1);

        public Builder process(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

