/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CheckDNSAvailabilityResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, CheckDNSAvailabilityResponse> {
    private final Boolean available;
    private final String fullyQualifiedCNAME;

    private CheckDNSAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.available = builder.available;
        this.fullyQualifiedCNAME = builder.fullyQualifiedCNAME;
    }

    public Boolean available() {
        return this.available;
    }

    public String fullyQualifiedCNAME() {
        return this.fullyQualifiedCNAME;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.available());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullyQualifiedCNAME());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDNSAvailabilityResponse)) {
            return false;
        }
        CheckDNSAvailabilityResponse other = (CheckDNSAvailabilityResponse)((Object)obj);
        return Objects.equals(this.available(), other.available()) && Objects.equals(this.fullyQualifiedCNAME(), other.fullyQualifiedCNAME());
    }

    public String toString() {
        return ToString.builder((String)"CheckDNSAvailabilityResponse").add("Available", (Object)this.available()).add("FullyQualifiedCNAME", (Object)this.fullyQualifiedCNAME()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Available": {
                return Optional.of(clazz.cast(this.available()));
            }
            case "FullyQualifiedCNAME": {
                return Optional.of(clazz.cast(this.fullyQualifiedCNAME()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private Boolean available;
        private String fullyQualifiedCNAME;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDNSAvailabilityResponse model) {
            this.available(model.available);
            this.fullyQualifiedCNAME(model.fullyQualifiedCNAME);
        }

        public final Boolean getAvailable() {
            return this.available;
        }

        @Override
        public final Builder available(Boolean available) {
            this.available = available;
            return this;
        }

        public final void setAvailable(Boolean available) {
            this.available = available;
        }

        public final String getFullyQualifiedCNAME() {
            return this.fullyQualifiedCNAME;
        }

        @Override
        public final Builder fullyQualifiedCNAME(String fullyQualifiedCNAME) {
            this.fullyQualifiedCNAME = fullyQualifiedCNAME;
            return this;
        }

        public final void setFullyQualifiedCNAME(String fullyQualifiedCNAME) {
            this.fullyQualifiedCNAME = fullyQualifiedCNAME;
        }

        @Override
        public CheckDNSAvailabilityResponse build() {
            return new CheckDNSAvailabilityResponse(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    CopyableBuilder<Builder, CheckDNSAvailabilityResponse> {
        public Builder available(Boolean var1);

        public Builder fullyQualifiedCNAME(String var1);
    }
}

