/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationResourceLifecycleConfig
implements ToCopyableBuilder<Builder, ApplicationResourceLifecycleConfig> {
    private final String serviceRole;
    private final ApplicationVersionLifecycleConfig versionLifecycleConfig;

    private ApplicationResourceLifecycleConfig(BuilderImpl builder) {
        this.serviceRole = builder.serviceRole;
        this.versionLifecycleConfig = builder.versionLifecycleConfig;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public ApplicationVersionLifecycleConfig versionLifecycleConfig() {
        return this.versionLifecycleConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLifecycleConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationResourceLifecycleConfig)) {
            return false;
        }
        ApplicationResourceLifecycleConfig other = (ApplicationResourceLifecycleConfig)obj;
        return Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.versionLifecycleConfig(), other.versionLifecycleConfig());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationResourceLifecycleConfig").add("ServiceRole", (Object)this.serviceRole()).add("VersionLifecycleConfig", (Object)this.versionLifecycleConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceRole": {
                return Optional.of(clazz.cast(this.serviceRole()));
            }
            case "VersionLifecycleConfig": {
                return Optional.of(clazz.cast(this.versionLifecycleConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceRole;
        private ApplicationVersionLifecycleConfig versionLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationResourceLifecycleConfig model) {
            this.serviceRole(model.serviceRole);
            this.versionLifecycleConfig(model.versionLifecycleConfig);
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final ApplicationVersionLifecycleConfig.Builder getVersionLifecycleConfig() {
            return this.versionLifecycleConfig != null ? this.versionLifecycleConfig.toBuilder() : null;
        }

        @Override
        public final Builder versionLifecycleConfig(ApplicationVersionLifecycleConfig versionLifecycleConfig) {
            this.versionLifecycleConfig = versionLifecycleConfig;
            return this;
        }

        public final void setVersionLifecycleConfig(ApplicationVersionLifecycleConfig.BuilderImpl versionLifecycleConfig) {
            this.versionLifecycleConfig = versionLifecycleConfig != null ? versionLifecycleConfig.build() : null;
        }

        public ApplicationResourceLifecycleConfig build() {
            return new ApplicationResourceLifecycleConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationResourceLifecycleConfig> {
        public Builder serviceRole(String var1);

        public Builder versionLifecycleConfig(ApplicationVersionLifecycleConfig var1);

        default public Builder versionLifecycleConfig(Consumer<ApplicationVersionLifecycleConfig.Builder> versionLifecycleConfig) {
            return this.versionLifecycleConfig((ApplicationVersionLifecycleConfig)((ApplicationVersionLifecycleConfig.Builder)ApplicationVersionLifecycleConfig.builder().apply(versionLifecycleConfig)).build());
        }
    }
}

