/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.CustomAmi;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFramework;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformProgrammingLanguage;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CustomAmiUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.PlatformFrameworkUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.PlatformProgrammingLanguageUnmarshaller;

public class PlatformDescriptionUnmarshaller
implements Unmarshaller<PlatformDescription, StaxUnmarshallerContext> {
    private static final PlatformDescriptionUnmarshaller INSTANCE = new PlatformDescriptionUnmarshaller();

    public PlatformDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        PlatformDescription.Builder platformDescription;
        block26: {
            platformDescription = PlatformDescription.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<PlatformProgrammingLanguage> programmingLanguages = null;
            ArrayList<PlatformFramework> frameworks = null;
            ArrayList<CustomAmi> customAmiList = null;
            ArrayList<String> supportedTierList = null;
            ArrayList<String> supportedAddonList = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    platformDescription.programmingLanguages(programmingLanguages);
                    platformDescription.frameworks(frameworks);
                    platformDescription.customAmiList(customAmiList);
                    platformDescription.supportedTierList(supportedTierList);
                    platformDescription.supportedAddonList(supportedAddonList);
                    break block26;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("PlatformArn", targetDepth)) {
                        platformDescription.platformArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("PlatformOwner", targetDepth)) {
                        platformDescription.platformOwner(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("PlatformName", targetDepth)) {
                        platformDescription.platformName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("PlatformVersion", targetDepth)) {
                        platformDescription.platformVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SolutionStackName", targetDepth)) {
                        platformDescription.solutionStackName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("PlatformStatus", targetDepth)) {
                        platformDescription.platformStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DateCreated", targetDepth)) {
                        platformDescription.dateCreated(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DateUpdated", targetDepth)) {
                        platformDescription.dateUpdated(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("PlatformCategory", targetDepth)) {
                        platformDescription.platformCategory(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Description", targetDepth)) {
                        platformDescription.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Maintainer", targetDepth)) {
                        platformDescription.maintainer(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OperatingSystemName", targetDepth)) {
                        platformDescription.operatingSystemName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OperatingSystemVersion", targetDepth)) {
                        platformDescription.operatingSystemVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ProgrammingLanguages", targetDepth)) {
                        programmingLanguages = new ArrayList<PlatformProgrammingLanguage>();
                        continue;
                    }
                    if (context.testExpression("ProgrammingLanguages/member", targetDepth)) {
                        programmingLanguages.add(PlatformProgrammingLanguageUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Frameworks", targetDepth)) {
                        frameworks = new ArrayList<PlatformFramework>();
                        continue;
                    }
                    if (context.testExpression("Frameworks/member", targetDepth)) {
                        frameworks.add(PlatformFrameworkUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CustomAmiList", targetDepth)) {
                        customAmiList = new ArrayList<CustomAmi>();
                        continue;
                    }
                    if (context.testExpression("CustomAmiList/member", targetDepth)) {
                        customAmiList.add(CustomAmiUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SupportedTierList", targetDepth)) {
                        supportedTierList = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("SupportedTierList/member", targetDepth)) {
                        supportedTierList.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SupportedAddonList", targetDepth)) {
                        supportedAddonList = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("SupportedAddonList/member", targetDepth)) continue;
                    supportedAddonList.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            platformDescription.programmingLanguages(programmingLanguages);
            platformDescription.frameworks(frameworks);
            platformDescription.customAmiList(customAmiList);
            platformDescription.supportedTierList(supportedTierList);
            platformDescription.supportedAddonList(supportedAddonList);
        }
        return (PlatformDescription)platformDescription.build();
    }

    public static PlatformDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

