/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.MaxAgeRule;

public class MaxAgeRuleUnmarshaller
implements Unmarshaller<MaxAgeRule, StaxUnmarshallerContext> {
    private static final MaxAgeRuleUnmarshaller INSTANCE = new MaxAgeRuleUnmarshaller();

    public MaxAgeRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        MaxAgeRule.Builder maxAgeRule = MaxAgeRule.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Enabled", targetDepth)) {
                    maxAgeRule.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxAgeInDays", targetDepth)) {
                    maxAgeRule.maxAgeInDays(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DeleteSourceFromS3", targetDepth)) continue;
                maxAgeRule.deleteSourceFromS3(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (MaxAgeRule)maxAgeRule.build();
    }

    public static MaxAgeRuleUnmarshaller getInstance() {
        return INSTANCE;
    }
}

