/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;
import software.amazon.awssdk.services.elasticbeanstalk.model.Tag;

public class CreateEnvironmentRequestMarshaller
implements Marshaller<Request<CreateEnvironmentRequest>, CreateEnvironmentRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateEnvironmentRequest> marshall(CreateEnvironmentRequest createEnvironmentRequest) {
        List<OptionSpecification> optionsToRemoveList;
        List<ConfigurationOptionSetting> optionSettingsList;
        List<Tag> tagsList;
        EnvironmentTier tier;
        if (createEnvironmentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createEnvironmentRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "CreateEnvironment");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createEnvironmentRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)createEnvironmentRequest.applicationName()));
        }
        if (createEnvironmentRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)createEnvironmentRequest.environmentName()));
        }
        if (createEnvironmentRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)createEnvironmentRequest.groupName()));
        }
        if (createEnvironmentRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createEnvironmentRequest.description()));
        }
        if (createEnvironmentRequest.cnamePrefix() != null) {
            request.addParameter("CNAMEPrefix", StringUtils.fromString((String)createEnvironmentRequest.cnamePrefix()));
        }
        if ((tier = createEnvironmentRequest.tier()) != null) {
            if (tier.name() != null) {
                request.addParameter("Tier.Name", StringUtils.fromString((String)tier.name()));
            }
            if (tier.type() != null) {
                request.addParameter("Tier.Type", StringUtils.fromString((String)tier.type()));
            }
            if (tier.version() != null) {
                request.addParameter("Tier.Version", StringUtils.fromString((String)tier.version()));
            }
        }
        if ((tagsList = createEnvironmentRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tag : tagsList) {
                    if (tag.key() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tag.key()));
                    }
                    if (tag.value() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tag.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (createEnvironmentRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)createEnvironmentRequest.versionLabel()));
        }
        if (createEnvironmentRequest.templateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)createEnvironmentRequest.templateName()));
        }
        if (createEnvironmentRequest.solutionStackName() != null) {
            request.addParameter("SolutionStackName", StringUtils.fromString((String)createEnvironmentRequest.solutionStackName()));
        }
        if (createEnvironmentRequest.platformArn() != null) {
            request.addParameter("PlatformArn", StringUtils.fromString((String)createEnvironmentRequest.platformArn()));
        }
        if ((optionSettingsList = createEnvironmentRequest.optionSettings()) != null) {
            if (!optionSettingsList.isEmpty()) {
                int optionSettingsListIndex = 1;
                for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                    if (optionSettingsListValue.resourceName() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringUtils.fromString((String)optionSettingsListValue.resourceName()));
                    }
                    if (optionSettingsListValue.namespace() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString((String)optionSettingsListValue.namespace()));
                    }
                    if (optionSettingsListValue.optionName() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString((String)optionSettingsListValue.optionName()));
                    }
                    if (optionSettingsListValue.value() != null) {
                        request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString((String)optionSettingsListValue.value()));
                    }
                    ++optionSettingsListIndex;
                }
            } else {
                request.addParameter("OptionSettings", "");
            }
        }
        if ((optionsToRemoveList = createEnvironmentRequest.optionsToRemove()) != null) {
            if (!optionsToRemoveList.isEmpty()) {
                boolean bl = true;
                for (OptionSpecification optionsToRemoveListValue : optionsToRemoveList) {
                    void var7_13;
                    if (optionsToRemoveListValue.resourceName() != null) {
                        request.addParameter("OptionsToRemove.member." + (int)var7_13 + ".ResourceName", StringUtils.fromString((String)optionsToRemoveListValue.resourceName()));
                    }
                    if (optionsToRemoveListValue.namespace() != null) {
                        request.addParameter("OptionsToRemove.member." + (int)var7_13 + ".Namespace", StringUtils.fromString((String)optionsToRemoveListValue.namespace()));
                    }
                    if (optionsToRemoveListValue.optionName() != null) {
                        request.addParameter("OptionsToRemove.member." + (int)var7_13 + ".OptionName", StringUtils.fromString((String)optionsToRemoveListValue.optionName()));
                    }
                    ++var7_13;
                }
            } else {
                request.addParameter("OptionsToRemove", "");
            }
        }
        return request;
    }
}

