/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealth;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentLink;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentLinksCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourcesDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateEnvironmentResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, UpdateEnvironmentResponse> {
    private final String environmentName;
    private final String environmentId;
    private final String applicationName;
    private final String versionLabel;
    private final String solutionStackName;
    private final String platformArn;
    private final String templateName;
    private final String description;
    private final String endpointURL;
    private final String cname;
    private final Instant dateCreated;
    private final Instant dateUpdated;
    private final String status;
    private final Boolean abortableOperationInProgress;
    private final String health;
    private final String healthStatus;
    private final EnvironmentResourcesDescription resources;
    private final EnvironmentTier tier;
    private final List<EnvironmentLink> environmentLinks;
    private final String environmentArn;

    private UpdateEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.environmentName = builder.environmentName;
        this.environmentId = builder.environmentId;
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.endpointURL = builder.endpointURL;
        this.cname = builder.cname;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.status = builder.status;
        this.abortableOperationInProgress = builder.abortableOperationInProgress;
        this.health = builder.health;
        this.healthStatus = builder.healthStatus;
        this.resources = builder.resources;
        this.tier = builder.tier;
        this.environmentLinks = builder.environmentLinks;
        this.environmentArn = builder.environmentArn;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public String templateName() {
        return this.templateName;
    }

    public String description() {
        return this.description;
    }

    public String endpointURL() {
        return this.endpointURL;
    }

    public String cname() {
        return this.cname;
    }

    public Instant dateCreated() {
        return this.dateCreated;
    }

    public Instant dateUpdated() {
        return this.dateUpdated;
    }

    public EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Boolean abortableOperationInProgress() {
        return this.abortableOperationInProgress;
    }

    public EnvironmentHealth health() {
        return EnvironmentHealth.fromValue(this.health);
    }

    public String healthString() {
        return this.health;
    }

    public EnvironmentHealthStatus healthStatus() {
        return EnvironmentHealthStatus.fromValue(this.healthStatus);
    }

    public String healthStatusString() {
        return this.healthStatus;
    }

    public EnvironmentResourcesDescription resources() {
        return this.resources;
    }

    public EnvironmentTier tier() {
        return this.tier;
    }

    public List<EnvironmentLink> environmentLinks() {
        return this.environmentLinks;
    }

    public String environmentArn() {
        return this.environmentArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.cname());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.abortableOperationInProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        hashCode = 31 * hashCode + Objects.hashCode(this.tier());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentLinks());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentResponse)) {
            return false;
        }
        UpdateEnvironmentResponse other = (UpdateEnvironmentResponse)((Object)obj);
        return Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.solutionStackName(), other.solutionStackName()) && Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.endpointURL(), other.endpointURL()) && Objects.equals(this.cname(), other.cname()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateUpdated(), other.dateUpdated()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.abortableOperationInProgress(), other.abortableOperationInProgress()) && Objects.equals(this.healthString(), other.healthString()) && Objects.equals(this.healthStatusString(), other.healthStatusString()) && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.tier(), other.tier()) && Objects.equals(this.environmentLinks(), other.environmentLinks()) && Objects.equals(this.environmentArn(), other.environmentArn());
    }

    public String toString() {
        return ToString.builder((String)"UpdateEnvironmentResponse").add("EnvironmentName", (Object)this.environmentName()).add("EnvironmentId", (Object)this.environmentId()).add("ApplicationName", (Object)this.applicationName()).add("VersionLabel", (Object)this.versionLabel()).add("SolutionStackName", (Object)this.solutionStackName()).add("PlatformArn", (Object)this.platformArn()).add("TemplateName", (Object)this.templateName()).add("Description", (Object)this.description()).add("EndpointURL", (Object)this.endpointURL()).add("CNAME", (Object)this.cname()).add("DateCreated", (Object)this.dateCreated()).add("DateUpdated", (Object)this.dateUpdated()).add("Status", (Object)this.statusString()).add("AbortableOperationInProgress", (Object)this.abortableOperationInProgress()).add("Health", (Object)this.healthString()).add("HealthStatus", (Object)this.healthStatusString()).add("Resources", (Object)this.resources()).add("Tier", (Object)this.tier()).add("EnvironmentLinks", this.environmentLinks()).add("EnvironmentArn", (Object)this.environmentArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnvironmentName": {
                return Optional.of(clazz.cast(this.environmentName()));
            }
            case "EnvironmentId": {
                return Optional.of(clazz.cast(this.environmentId()));
            }
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "VersionLabel": {
                return Optional.of(clazz.cast(this.versionLabel()));
            }
            case "SolutionStackName": {
                return Optional.of(clazz.cast(this.solutionStackName()));
            }
            case "PlatformArn": {
                return Optional.of(clazz.cast(this.platformArn()));
            }
            case "TemplateName": {
                return Optional.of(clazz.cast(this.templateName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "EndpointURL": {
                return Optional.of(clazz.cast(this.endpointURL()));
            }
            case "CNAME": {
                return Optional.of(clazz.cast(this.cname()));
            }
            case "DateCreated": {
                return Optional.of(clazz.cast(this.dateCreated()));
            }
            case "DateUpdated": {
                return Optional.of(clazz.cast(this.dateUpdated()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "AbortableOperationInProgress": {
                return Optional.of(clazz.cast(this.abortableOperationInProgress()));
            }
            case "Health": {
                return Optional.of(clazz.cast(this.healthString()));
            }
            case "HealthStatus": {
                return Optional.of(clazz.cast(this.healthStatusString()));
            }
            case "Resources": {
                return Optional.of(clazz.cast(this.resources()));
            }
            case "Tier": {
                return Optional.of(clazz.cast(this.tier()));
            }
            case "EnvironmentLinks": {
                return Optional.of(clazz.cast(this.environmentLinks()));
            }
            case "EnvironmentArn": {
                return Optional.of(clazz.cast(this.environmentArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private String environmentName;
        private String environmentId;
        private String applicationName;
        private String versionLabel;
        private String solutionStackName;
        private String platformArn;
        private String templateName;
        private String description;
        private String endpointURL;
        private String cname;
        private Instant dateCreated;
        private Instant dateUpdated;
        private String status;
        private Boolean abortableOperationInProgress;
        private String health;
        private String healthStatus;
        private EnvironmentResourcesDescription resources;
        private EnvironmentTier tier;
        private List<EnvironmentLink> environmentLinks;
        private String environmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentResponse model) {
            this.environmentName(model.environmentName);
            this.environmentId(model.environmentId);
            this.applicationName(model.applicationName);
            this.versionLabel(model.versionLabel);
            this.solutionStackName(model.solutionStackName);
            this.platformArn(model.platformArn);
            this.templateName(model.templateName);
            this.description(model.description);
            this.endpointURL(model.endpointURL);
            this.cname(model.cname);
            this.dateCreated(model.dateCreated);
            this.dateUpdated(model.dateUpdated);
            this.status(model.status);
            this.abortableOperationInProgress(model.abortableOperationInProgress);
            this.health(model.health);
            this.healthStatus(model.healthStatus);
            this.resources(model.resources);
            this.tier(model.tier);
            this.environmentLinks(model.environmentLinks);
            this.environmentArn(model.environmentArn);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEndpointURL() {
            return this.endpointURL;
        }

        @Override
        public final Builder endpointURL(String endpointURL) {
            this.endpointURL = endpointURL;
            return this;
        }

        public final void setEndpointURL(String endpointURL) {
            this.endpointURL = endpointURL;
        }

        public final String getCNAME() {
            return this.cname;
        }

        @Override
        public final Builder cname(String cname) {
            this.cname = cname;
            return this;
        }

        public final void setCNAME(String cname) {
            this.cname = cname;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateUpdated() {
            return this.dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getAbortableOperationInProgress() {
            return this.abortableOperationInProgress;
        }

        @Override
        public final Builder abortableOperationInProgress(Boolean abortableOperationInProgress) {
            this.abortableOperationInProgress = abortableOperationInProgress;
            return this;
        }

        public final void setAbortableOperationInProgress(Boolean abortableOperationInProgress) {
            this.abortableOperationInProgress = abortableOperationInProgress;
        }

        public final String getHealth() {
            return this.health;
        }

        @Override
        public final Builder health(String health) {
            this.health = health;
            return this;
        }

        @Override
        public final Builder health(EnvironmentHealth health) {
            this.health(health.toString());
            return this;
        }

        public final void setHealth(String health) {
            this.health = health;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(EnvironmentHealthStatus healthStatus) {
            this.healthStatus(healthStatus.toString());
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final EnvironmentResourcesDescription.Builder getResources() {
            return this.resources != null ? this.resources.toBuilder() : null;
        }

        @Override
        public final Builder resources(EnvironmentResourcesDescription resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(EnvironmentResourcesDescription.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        public final EnvironmentTier.Builder getTier() {
            return this.tier != null ? this.tier.toBuilder() : null;
        }

        @Override
        public final Builder tier(EnvironmentTier tier) {
            this.tier = tier;
            return this;
        }

        public final void setTier(EnvironmentTier.BuilderImpl tier) {
            this.tier = tier != null ? tier.build() : null;
        }

        public final Collection<EnvironmentLink.Builder> getEnvironmentLinks() {
            return this.environmentLinks != null ? (Collection)this.environmentLinks.stream().map(EnvironmentLink::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environmentLinks(Collection<EnvironmentLink> environmentLinks) {
            this.environmentLinks = EnvironmentLinksCopier.copy(environmentLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentLinks(EnvironmentLink ... environmentLinks) {
            this.environmentLinks(Arrays.asList(environmentLinks));
            return this;
        }

        public final void setEnvironmentLinks(Collection<EnvironmentLink.BuilderImpl> environmentLinks) {
            this.environmentLinks = EnvironmentLinksCopier.copyFromBuilder(environmentLinks);
        }

        public final String getEnvironmentArn() {
            return this.environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        public UpdateEnvironmentResponse build() {
            return new UpdateEnvironmentResponse(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    CopyableBuilder<Builder, UpdateEnvironmentResponse> {
        public Builder environmentName(String var1);

        public Builder environmentId(String var1);

        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder templateName(String var1);

        public Builder description(String var1);

        public Builder endpointURL(String var1);

        public Builder cname(String var1);

        public Builder dateCreated(Instant var1);

        public Builder dateUpdated(Instant var1);

        public Builder status(String var1);

        public Builder status(EnvironmentStatus var1);

        public Builder abortableOperationInProgress(Boolean var1);

        public Builder health(String var1);

        public Builder health(EnvironmentHealth var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(EnvironmentHealthStatus var1);

        public Builder resources(EnvironmentResourcesDescription var1);

        default public Builder resources(Consumer<EnvironmentResourcesDescription.Builder> resources) {
            return this.resources((EnvironmentResourcesDescription)((EnvironmentResourcesDescription.Builder)EnvironmentResourcesDescription.builder().apply(resources)).build());
        }

        public Builder tier(EnvironmentTier var1);

        default public Builder tier(Consumer<EnvironmentTier.Builder> tier) {
            return this.tier((EnvironmentTier)((EnvironmentTier.Builder)EnvironmentTier.builder().apply(tier)).build());
        }

        public Builder environmentLinks(Collection<EnvironmentLink> var1);

        public Builder environmentLinks(EnvironmentLink ... var1);

        public Builder environmentArn(String var1);
    }
}

