/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSettingsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionsSpecifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateConfigurationTemplateRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, UpdateConfigurationTemplateRequest> {
    private final String applicationName;
    private final String templateName;
    private final String description;
    private final List<ConfigurationOptionSetting> optionSettings;
    private final List<OptionSpecification> optionsToRemove;

    private UpdateConfigurationTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.optionSettings = builder.optionSettings;
        this.optionsToRemove = builder.optionsToRemove;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String templateName() {
        return this.templateName;
    }

    public String description() {
        return this.description;
    }

    public List<ConfigurationOptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public List<OptionSpecification> optionsToRemove() {
        return this.optionsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionsToRemove());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationTemplateRequest)) {
            return false;
        }
        UpdateConfigurationTemplateRequest other = (UpdateConfigurationTemplateRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.optionSettings(), other.optionSettings()) && Objects.equals(this.optionsToRemove(), other.optionsToRemove());
    }

    public String toString() {
        return ToString.builder((String)"UpdateConfigurationTemplateRequest").add("ApplicationName", (Object)this.applicationName()).add("TemplateName", (Object)this.templateName()).add("Description", (Object)this.description()).add("OptionSettings", this.optionSettings()).add("OptionsToRemove", this.optionsToRemove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "TemplateName": {
                return Optional.of(clazz.cast(this.templateName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "OptionSettings": {
                return Optional.of(clazz.cast(this.optionSettings()));
            }
            case "OptionsToRemove": {
                return Optional.of(clazz.cast(this.optionsToRemove()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String templateName;
        private String description;
        private List<ConfigurationOptionSetting> optionSettings;
        private List<OptionSpecification> optionsToRemove;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationTemplateRequest model) {
            this.applicationName(model.applicationName);
            this.templateName(model.templateName);
            this.description(model.description);
            this.optionSettings(model.optionSettings);
            this.optionsToRemove(model.optionsToRemove);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<ConfigurationOptionSetting.Builder> getOptionSettings() {
            return this.optionSettings != null ? (Collection)this.optionSettings.stream().map(ConfigurationOptionSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copyFromBuilder(optionSettings);
        }

        public final Collection<OptionSpecification.Builder> getOptionsToRemove() {
            return this.optionsToRemove != null ? (Collection)this.optionsToRemove.stream().map(OptionSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionsToRemove(Collection<OptionSpecification> optionsToRemove) {
            this.optionsToRemove = OptionsSpecifierListCopier.copy(optionsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsToRemove(OptionSpecification ... optionsToRemove) {
            this.optionsToRemove(Arrays.asList(optionsToRemove));
            return this;
        }

        public final void setOptionsToRemove(Collection<OptionSpecification.BuilderImpl> optionsToRemove) {
            this.optionsToRemove = OptionsSpecifierListCopier.copyFromBuilder(optionsToRemove);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationTemplateRequest build() {
            return new UpdateConfigurationTemplateRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, UpdateConfigurationTemplateRequest> {
        public Builder applicationName(String var1);

        public Builder templateName(String var1);

        public Builder description(String var1);

        public Builder optionSettings(Collection<ConfigurationOptionSetting> var1);

        public Builder optionSettings(ConfigurationOptionSetting ... var1);

        public Builder optionsToRemove(Collection<OptionSpecification> var1);

        public Builder optionsToRemove(OptionSpecification ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

