/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionHistoryStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionType;
import software.amazon.awssdk.services.elasticbeanstalk.model.FailureType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ManagedActionHistoryItem
implements ToCopyableBuilder<Builder, ManagedActionHistoryItem> {
    private final String actionId;
    private final String actionType;
    private final String actionDescription;
    private final String failureType;
    private final String status;
    private final String failureDescription;
    private final Instant executedTime;
    private final Instant finishedTime;

    private ManagedActionHistoryItem(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.actionType = builder.actionType;
        this.actionDescription = builder.actionDescription;
        this.failureType = builder.failureType;
        this.status = builder.status;
        this.failureDescription = builder.failureDescription;
        this.executedTime = builder.executedTime;
        this.finishedTime = builder.finishedTime;
    }

    public String actionId() {
        return this.actionId;
    }

    public ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public String actionTypeString() {
        return this.actionType;
    }

    public String actionDescription() {
        return this.actionDescription;
    }

    public FailureType failureType() {
        return FailureType.fromValue(this.failureType);
    }

    public String failureTypeString() {
        return this.failureType;
    }

    public ActionHistoryStatus status() {
        return ActionHistoryStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String failureDescription() {
        return this.failureDescription;
    }

    public Instant executedTime() {
        return this.executedTime;
    }

    public Instant finishedTime() {
        return this.finishedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.executedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.finishedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedActionHistoryItem)) {
            return false;
        }
        ManagedActionHistoryItem other = (ManagedActionHistoryItem)obj;
        return Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.actionTypeString(), other.actionTypeString()) && Objects.equals(this.actionDescription(), other.actionDescription()) && Objects.equals(this.failureTypeString(), other.failureTypeString()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.failureDescription(), other.failureDescription()) && Objects.equals(this.executedTime(), other.executedTime()) && Objects.equals(this.finishedTime(), other.finishedTime());
    }

    public String toString() {
        return ToString.builder((String)"ManagedActionHistoryItem").add("ActionId", (Object)this.actionId()).add("ActionType", (Object)this.actionTypeString()).add("ActionDescription", (Object)this.actionDescription()).add("FailureType", (Object)this.failureTypeString()).add("Status", (Object)this.statusString()).add("FailureDescription", (Object)this.failureDescription()).add("ExecutedTime", (Object)this.executedTime()).add("FinishedTime", (Object)this.finishedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionId": {
                return Optional.of(clazz.cast(this.actionId()));
            }
            case "ActionType": {
                return Optional.of(clazz.cast(this.actionTypeString()));
            }
            case "ActionDescription": {
                return Optional.of(clazz.cast(this.actionDescription()));
            }
            case "FailureType": {
                return Optional.of(clazz.cast(this.failureTypeString()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "FailureDescription": {
                return Optional.of(clazz.cast(this.failureDescription()));
            }
            case "ExecutedTime": {
                return Optional.of(clazz.cast(this.executedTime()));
            }
            case "FinishedTime": {
                return Optional.of(clazz.cast(this.finishedTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String actionId;
        private String actionType;
        private String actionDescription;
        private String failureType;
        private String status;
        private String failureDescription;
        private Instant executedTime;
        private Instant finishedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedActionHistoryItem model) {
            this.actionId(model.actionId);
            this.actionType(model.actionType);
            this.actionDescription(model.actionDescription);
            this.failureType(model.failureType);
            this.status(model.status);
            this.failureDescription(model.failureDescription);
            this.executedTime(model.executedTime);
            this.finishedTime(model.finishedTime);
        }

        public final String getActionId() {
            return this.actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getActionType() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getActionDescription() {
            return this.actionDescription;
        }

        @Override
        public final Builder actionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
            return this;
        }

        public final void setActionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
        }

        public final String getFailureType() {
            return this.failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        public final Builder failureType(FailureType failureType) {
            this.failureType(failureType.toString());
            return this;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionHistoryStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFailureDescription() {
            return this.failureDescription;
        }

        @Override
        public final Builder failureDescription(String failureDescription) {
            this.failureDescription = failureDescription;
            return this;
        }

        public final void setFailureDescription(String failureDescription) {
            this.failureDescription = failureDescription;
        }

        public final Instant getExecutedTime() {
            return this.executedTime;
        }

        @Override
        public final Builder executedTime(Instant executedTime) {
            this.executedTime = executedTime;
            return this;
        }

        public final void setExecutedTime(Instant executedTime) {
            this.executedTime = executedTime;
        }

        public final Instant getFinishedTime() {
            return this.finishedTime;
        }

        @Override
        public final Builder finishedTime(Instant finishedTime) {
            this.finishedTime = finishedTime;
            return this;
        }

        public final void setFinishedTime(Instant finishedTime) {
            this.finishedTime = finishedTime;
        }

        public ManagedActionHistoryItem build() {
            return new ManagedActionHistoryItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ManagedActionHistoryItem> {
        public Builder actionId(String var1);

        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder actionDescription(String var1);

        public Builder failureType(String var1);

        public Builder failureType(FailureType var1);

        public Builder status(String var1);

        public Builder status(ActionHistoryStatus var1);

        public Builder failureDescription(String var1);

        public Builder executedTime(Instant var1);

        public Builder finishedTime(Instant var1);
    }
}

