/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPlatformVersionsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, ListPlatformVersionsResponse> {
    private final List<PlatformSummary> platformSummaryList;
    private final String nextToken;

    private ListPlatformVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.platformSummaryList = builder.platformSummaryList;
        this.nextToken = builder.nextToken;
    }

    public List<PlatformSummary> platformSummaryList() {
        return this.platformSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformVersionsResponse)) {
            return false;
        }
        ListPlatformVersionsResponse other = (ListPlatformVersionsResponse)((Object)obj);
        return Objects.equals(this.platformSummaryList(), other.platformSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPlatformVersionsResponse").add("PlatformSummaryList", this.platformSummaryList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformSummaryList": {
                return Optional.of(clazz.cast(this.platformSummaryList()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<PlatformSummary> platformSummaryList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformVersionsResponse model) {
            this.platformSummaryList(model.platformSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<PlatformSummary.Builder> getPlatformSummaryList() {
            return this.platformSummaryList != null ? (Collection)this.platformSummaryList.stream().map(PlatformSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder platformSummaryList(Collection<PlatformSummary> platformSummaryList) {
            this.platformSummaryList = PlatformSummaryListCopier.copy(platformSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformSummaryList(PlatformSummary ... platformSummaryList) {
            this.platformSummaryList(Arrays.asList(platformSummaryList));
            return this;
        }

        public final void setPlatformSummaryList(Collection<PlatformSummary.BuilderImpl> platformSummaryList) {
            this.platformSummaryList = PlatformSummaryListCopier.copyFromBuilder(platformSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPlatformVersionsResponse build() {
            return new ListPlatformVersionsResponse(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    CopyableBuilder<Builder, ListPlatformVersionsResponse> {
        public Builder platformSummaryList(Collection<PlatformSummary> var1);

        public Builder platformSummaryList(PlatformSummary ... var1);

        public Builder nextToken(String var1);
    }
}

