/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateApplicationRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private final String applicationName;
    private final String description;
    private final ApplicationResourceLifecycleConfig resourceLifecycleConfig;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.description = builder.description;
        this.resourceLifecycleConfig = builder.resourceLifecycleConfig;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String description() {
        return this.description;
    }

    public ApplicationResourceLifecycleConfig resourceLifecycleConfig() {
        return this.resourceLifecycleConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceLifecycleConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.resourceLifecycleConfig(), other.resourceLifecycleConfig());
    }

    public String toString() {
        return ToString.builder((String)"CreateApplicationRequest").add("ApplicationName", (Object)this.applicationName()).add("Description", (Object)this.description()).add("ResourceLifecycleConfig", (Object)this.resourceLifecycleConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ResourceLifecycleConfig": {
                return Optional.of(clazz.cast(this.resourceLifecycleConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String description;
        private ApplicationResourceLifecycleConfig resourceLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            this.applicationName(model.applicationName);
            this.description(model.description);
            this.resourceLifecycleConfig(model.resourceLifecycleConfig);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ApplicationResourceLifecycleConfig.Builder getResourceLifecycleConfig() {
            return this.resourceLifecycleConfig != null ? this.resourceLifecycleConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig;
            return this;
        }

        public final void setResourceLifecycleConfig(ApplicationResourceLifecycleConfig.BuilderImpl resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig != null ? resourceLifecycleConfig.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder description(String var1);

        public Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig var1);

        default public Builder resourceLifecycleConfig(Consumer<ApplicationResourceLifecycleConfig.Builder> resourceLifecycleConfig) {
            return this.resourceLifecycleConfig((ApplicationResourceLifecycleConfig)((ApplicationResourceLifecycleConfig.Builder)ApplicationResourceLifecycleConfig.builder().apply(resourceLifecycleConfig)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

