/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentDescriptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComposeEnvironmentsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, ComposeEnvironmentsResponse> {
    private final List<EnvironmentDescription> environments;
    private final String nextToken;

    private ComposeEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.environments = builder.environments;
        this.nextToken = builder.nextToken;
    }

    public List<EnvironmentDescription> environments() {
        return this.environments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environments());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComposeEnvironmentsResponse)) {
            return false;
        }
        ComposeEnvironmentsResponse other = (ComposeEnvironmentsResponse)((Object)obj);
        return Objects.equals(this.environments(), other.environments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ComposeEnvironmentsResponse").add("Environments", this.environments()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Environments": {
                return Optional.of(clazz.cast(this.environments()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<EnvironmentDescription> environments;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ComposeEnvironmentsResponse model) {
            this.environments(model.environments);
            this.nextToken(model.nextToken);
        }

        public final Collection<EnvironmentDescription.Builder> getEnvironments() {
            return this.environments != null ? (Collection)this.environments.stream().map(EnvironmentDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environments(Collection<EnvironmentDescription> environments) {
            this.environments = EnvironmentDescriptionsListCopier.copy(environments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(EnvironmentDescription ... environments) {
            this.environments(Arrays.asList(environments));
            return this;
        }

        public final void setEnvironments(Collection<EnvironmentDescription.BuilderImpl> environments) {
            this.environments = EnvironmentDescriptionsListCopier.copyFromBuilder(environments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ComposeEnvironmentsResponse build() {
            return new ComposeEnvironmentsResponse(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    CopyableBuilder<Builder, ComposeEnvironmentsResponse> {
        public Builder environments(Collection<EnvironmentDescription> var1);

        public Builder environments(EnvironmentDescription ... var1);

        public Builder nextToken(String var1);
    }
}

