/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.VersionLabelsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComposeEnvironmentsRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, ComposeEnvironmentsRequest> {
    private final String applicationName;
    private final String groupName;
    private final List<String> versionLabels;

    private ComposeEnvironmentsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.groupName = builder.groupName;
        this.versionLabels = builder.versionLabels;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String groupName() {
        return this.groupName;
    }

    public List<String> versionLabels() {
        return this.versionLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComposeEnvironmentsRequest)) {
            return false;
        }
        ComposeEnvironmentsRequest other = (ComposeEnvironmentsRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.versionLabels(), other.versionLabels());
    }

    public String toString() {
        return ToString.builder((String)"ComposeEnvironmentsRequest").add("ApplicationName", (Object)this.applicationName()).add("GroupName", (Object)this.groupName()).add("VersionLabels", this.versionLabels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "VersionLabels": {
                return Optional.of(clazz.cast(this.versionLabels()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String groupName;
        private List<String> versionLabels;

        private BuilderImpl() {
        }

        private BuilderImpl(ComposeEnvironmentsRequest model) {
            this.applicationName(model.applicationName);
            this.groupName(model.groupName);
            this.versionLabels(model.versionLabels);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Collection<String> getVersionLabels() {
            return this.versionLabels;
        }

        @Override
        public final Builder versionLabels(Collection<String> versionLabels) {
            this.versionLabels = VersionLabelsCopier.copy(versionLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionLabels(String ... versionLabels) {
            this.versionLabels(Arrays.asList(versionLabels));
            return this;
        }

        public final void setVersionLabels(Collection<String> versionLabels) {
            this.versionLabels = VersionLabelsCopier.copy(versionLabels);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ComposeEnvironmentsRequest build() {
            return new ComposeEnvironmentsRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, ComposeEnvironmentsRequest> {
        public Builder applicationName(String var1);

        public Builder groupName(String var1);

        public Builder versionLabels(Collection<String> var1);

        public Builder versionLabels(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

