/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationVersionRequest;

public class UpdateApplicationVersionRequestMarshaller
implements Marshaller<Request<UpdateApplicationVersionRequest>, UpdateApplicationVersionRequest> {
    public Request<UpdateApplicationVersionRequest> marshall(UpdateApplicationVersionRequest updateApplicationVersionRequest) {
        if (updateApplicationVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)updateApplicationVersionRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "UpdateApplicationVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateApplicationVersionRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)updateApplicationVersionRequest.applicationName()));
        }
        if (updateApplicationVersionRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)updateApplicationVersionRequest.versionLabel()));
        }
        if (updateApplicationVersionRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)updateApplicationVersionRequest.description()));
        }
        return request;
    }
}

