/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.SingleInstanceHealth;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ApplicationMetricsUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeploymentUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.SystemStatusUnmarshaller;

public class SingleInstanceHealthUnmarshaller
implements Unmarshaller<SingleInstanceHealth, StaxUnmarshallerContext> {
    private static final SingleInstanceHealthUnmarshaller INSTANCE = new SingleInstanceHealthUnmarshaller();

    public SingleInstanceHealth unmarshall(StaxUnmarshallerContext context) throws Exception {
        SingleInstanceHealth.Builder singleInstanceHealth;
        block14: {
            singleInstanceHealth = SingleInstanceHealth.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> causes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    singleInstanceHealth.causes(causes);
                    break block14;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("InstanceId", targetDepth)) {
                        singleInstanceHealth.instanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("HealthStatus", targetDepth)) {
                        singleInstanceHealth.healthStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Color", targetDepth)) {
                        singleInstanceHealth.color(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Causes", targetDepth)) {
                        causes = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("Causes/member", targetDepth)) {
                        causes.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("LaunchedAt", targetDepth)) {
                        singleInstanceHealth.launchedAt(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ApplicationMetrics", targetDepth)) {
                        singleInstanceHealth.applicationMetrics(ApplicationMetricsUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("System", targetDepth)) {
                        singleInstanceHealth.system(SystemStatusUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Deployment", targetDepth)) {
                        singleInstanceHealth.deployment(DeploymentUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AvailabilityZone", targetDepth)) {
                        singleInstanceHealth.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("InstanceType", targetDepth)) continue;
                    singleInstanceHealth.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            singleInstanceHealth.causes(causes);
        }
        return (SingleInstanceHealth)singleInstanceHealth.build();
    }

    public static SingleInstanceHealthUnmarshaller getInstance() {
        return INSTANCE;
    }
}

