/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationMetrics;
import software.amazon.awssdk.services.elasticbeanstalk.transform.LatencyUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.StatusCodesUnmarshaller;

public class ApplicationMetricsUnmarshaller
implements Unmarshaller<ApplicationMetrics, StaxUnmarshallerContext> {
    private static final ApplicationMetricsUnmarshaller INSTANCE = new ApplicationMetricsUnmarshaller();

    public ApplicationMetrics unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ApplicationMetrics.Builder applicationMetrics = ApplicationMetrics.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Duration", targetDepth)) {
                    applicationMetrics.duration(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequestCount", targetDepth)) {
                    applicationMetrics.requestCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StatusCodes", targetDepth)) {
                    applicationMetrics.statusCodes(StatusCodesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Latency", targetDepth)) continue;
                applicationMetrics.latency(LatencyUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ApplicationMetrics)applicationMetrics.build();
    }

    public static ApplicationMetricsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

