/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MaxAgeRule
implements ToCopyableBuilder<Builder, MaxAgeRule> {
    private final Boolean enabled;
    private final Integer maxAgeInDays;
    private final Boolean deleteSourceFromS3;

    private MaxAgeRule(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.maxAgeInDays = builder.maxAgeInDays;
        this.deleteSourceFromS3 = builder.deleteSourceFromS3;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Integer maxAgeInDays() {
        return this.maxAgeInDays;
    }

    public Boolean deleteSourceFromS3() {
        return this.deleteSourceFromS3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAgeInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteSourceFromS3());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaxAgeRule)) {
            return false;
        }
        MaxAgeRule other = (MaxAgeRule)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.maxAgeInDays(), other.maxAgeInDays()) && Objects.equals(this.deleteSourceFromS3(), other.deleteSourceFromS3());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.maxAgeInDays() != null) {
            sb.append("MaxAgeInDays: ").append(this.maxAgeInDays()).append(",");
        }
        if (this.deleteSourceFromS3() != null) {
            sb.append("DeleteSourceFromS3: ").append(this.deleteSourceFromS3()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "MaxAgeInDays": {
                return Optional.of(clazz.cast(this.maxAgeInDays()));
            }
            case "DeleteSourceFromS3": {
                return Optional.of(clazz.cast(this.deleteSourceFromS3()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Integer maxAgeInDays;
        private Boolean deleteSourceFromS3;

        private BuilderImpl() {
        }

        private BuilderImpl(MaxAgeRule model) {
            this.enabled(model.enabled);
            this.maxAgeInDays(model.maxAgeInDays);
            this.deleteSourceFromS3(model.deleteSourceFromS3);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getMaxAgeInDays() {
            return this.maxAgeInDays;
        }

        @Override
        public final Builder maxAgeInDays(Integer maxAgeInDays) {
            this.maxAgeInDays = maxAgeInDays;
            return this;
        }

        public final void setMaxAgeInDays(Integer maxAgeInDays) {
            this.maxAgeInDays = maxAgeInDays;
        }

        public final Boolean getDeleteSourceFromS3() {
            return this.deleteSourceFromS3;
        }

        @Override
        public final Builder deleteSourceFromS3(Boolean deleteSourceFromS3) {
            this.deleteSourceFromS3 = deleteSourceFromS3;
            return this;
        }

        public final void setDeleteSourceFromS3(Boolean deleteSourceFromS3) {
            this.deleteSourceFromS3 = deleteSourceFromS3;
        }

        public MaxAgeRule build() {
            return new MaxAgeRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaxAgeRule> {
        public Builder enabled(Boolean var1);

        public Builder maxAgeInDays(Integer var1);

        public Builder deleteSourceFromS3(Boolean var1);
    }
}

