/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Listener
implements ToCopyableBuilder<Builder, Listener> {
    private final String protocol;
    private final Integer port;

    private Listener(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.port = builder.port;
    }

    public String protocol() {
        return this.protocol;
    }

    public Integer port() {
        return this.port;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Listener)) {
            return false;
        }
        Listener other = (Listener)obj;
        return Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.port(), other.port());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.protocol() != null) {
            sb.append("Protocol: ").append(this.protocol()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocol()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;
        private Integer port;

        private BuilderImpl() {
        }

        private BuilderImpl(Listener model) {
            this.protocol(model.protocol);
            this.port(model.port);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public Listener build() {
            return new Listener(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Listener> {
        public Builder protocol(String var1);

        public Builder port(Integer var1);
    }
}

