/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedAction;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEnvironmentManagedActionsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeEnvironmentManagedActionsResponse> {
    private final List<ManagedAction> managedActions;

    private DescribeEnvironmentManagedActionsResponse(BuilderImpl builder) {
        super(builder);
        this.managedActions = builder.managedActions;
    }

    public List<ManagedAction> managedActions() {
        return this.managedActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.managedActions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentManagedActionsResponse)) {
            return false;
        }
        DescribeEnvironmentManagedActionsResponse other = (DescribeEnvironmentManagedActionsResponse)((Object)obj);
        return Objects.equals(this.managedActions(), other.managedActions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.managedActions() != null) {
            sb.append("ManagedActions: ").append(this.managedActions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedActions": {
                return Optional.of(clazz.cast(this.managedActions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<ManagedAction> managedActions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentManagedActionsResponse model) {
            this.managedActions(model.managedActions);
        }

        public final Collection<ManagedAction.Builder> getManagedActions() {
            return this.managedActions != null ? (Collection)this.managedActions.stream().map(ManagedAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder managedActions(Collection<ManagedAction> managedActions) {
            this.managedActions = ManagedActionsCopier.copy(managedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedActions(ManagedAction ... managedActions) {
            this.managedActions(Arrays.asList(managedActions));
            return this;
        }

        public final void setManagedActions(Collection<ManagedAction.BuilderImpl> managedActions) {
            this.managedActions = ManagedActionsCopier.copyFromBuilder(managedActions);
        }

        @Override
        public DescribeEnvironmentManagedActionsResponse build() {
            return new DescribeEnvironmentManagedActionsResponse(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    CopyableBuilder<Builder, DescribeEnvironmentManagedActionsResponse> {
        public Builder managedActions(Collection<ManagedAction> var1);

        public Builder managedActions(ManagedAction ... var1);
    }
}

