/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionsSpecifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeConfigurationOptionsRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, DescribeConfigurationOptionsRequest> {
    private final String applicationName;
    private final String templateName;
    private final String environmentName;
    private final String solutionStackName;
    private final String platformArn;
    private final List<OptionSpecification> options;

    private DescribeConfigurationOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.templateName = builder.templateName;
        this.environmentName = builder.environmentName;
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.options = builder.options;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String templateName() {
        return this.templateName;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public List<OptionSpecification> options() {
        return this.options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationOptionsRequest)) {
            return false;
        }
        DescribeConfigurationOptionsRequest other = (DescribeConfigurationOptionsRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.solutionStackName(), other.solutionStackName()) && Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.options(), other.options());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.templateName() != null) {
            sb.append("TemplateName: ").append(this.templateName()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.solutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.solutionStackName()).append(",");
        }
        if (this.platformArn() != null) {
            sb.append("PlatformArn: ").append(this.platformArn()).append(",");
        }
        if (this.options() != null) {
            sb.append("Options: ").append(this.options()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "TemplateName": {
                return Optional.of(clazz.cast(this.templateName()));
            }
            case "EnvironmentName": {
                return Optional.of(clazz.cast(this.environmentName()));
            }
            case "SolutionStackName": {
                return Optional.of(clazz.cast(this.solutionStackName()));
            }
            case "PlatformArn": {
                return Optional.of(clazz.cast(this.platformArn()));
            }
            case "Options": {
                return Optional.of(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String templateName;
        private String environmentName;
        private String solutionStackName;
        private String platformArn;
        private List<OptionSpecification> options;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationOptionsRequest model) {
            this.applicationName(model.applicationName);
            this.templateName(model.templateName);
            this.environmentName(model.environmentName);
            this.solutionStackName(model.solutionStackName);
            this.platformArn(model.platformArn);
            this.options(model.options);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final Collection<OptionSpecification.Builder> getOptions() {
            return this.options != null ? (Collection)this.options.stream().map(OptionSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder options(Collection<OptionSpecification> options) {
            this.options = OptionsSpecifierListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(OptionSpecification ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        public final void setOptions(Collection<OptionSpecification.BuilderImpl> options) {
            this.options = OptionsSpecifierListCopier.copyFromBuilder(options);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationOptionsRequest build() {
            return new DescribeConfigurationOptionsRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, DescribeConfigurationOptionsRequest> {
        public Builder applicationName(String var1);

        public Builder templateName(String var1);

        public Builder environmentName(String var1);

        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder options(Collection<OptionSpecification> var1);

        public Builder options(OptionSpecification ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

