/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSettingsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePlatformVersionRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, CreatePlatformVersionRequest> {
    private final String platformName;
    private final String platformVersion;
    private final S3Location platformDefinitionBundle;
    private final String environmentName;
    private final List<ConfigurationOptionSetting> optionSettings;

    private CreatePlatformVersionRequest(BuilderImpl builder) {
        super(builder);
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.platformDefinitionBundle = builder.platformDefinitionBundle;
        this.environmentName = builder.environmentName;
        this.optionSettings = builder.optionSettings;
    }

    public String platformName() {
        return this.platformName;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public S3Location platformDefinitionBundle() {
        return this.platformDefinitionBundle;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public List<ConfigurationOptionSetting> optionSettings() {
        return this.optionSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformDefinitionBundle());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformVersionRequest)) {
            return false;
        }
        CreatePlatformVersionRequest other = (CreatePlatformVersionRequest)((Object)obj);
        return Objects.equals(this.platformName(), other.platformName()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.platformDefinitionBundle(), other.platformDefinitionBundle()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.optionSettings(), other.optionSettings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.platformName() != null) {
            sb.append("PlatformName: ").append(this.platformName()).append(",");
        }
        if (this.platformVersion() != null) {
            sb.append("PlatformVersion: ").append(this.platformVersion()).append(",");
        }
        if (this.platformDefinitionBundle() != null) {
            sb.append("PlatformDefinitionBundle: ").append(this.platformDefinitionBundle()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.optionSettings() != null) {
            sb.append("OptionSettings: ").append(this.optionSettings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformName": {
                return Optional.of(clazz.cast(this.platformName()));
            }
            case "PlatformVersion": {
                return Optional.of(clazz.cast(this.platformVersion()));
            }
            case "PlatformDefinitionBundle": {
                return Optional.of(clazz.cast(this.platformDefinitionBundle()));
            }
            case "EnvironmentName": {
                return Optional.of(clazz.cast(this.environmentName()));
            }
            case "OptionSettings": {
                return Optional.of(clazz.cast(this.optionSettings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String platformName;
        private String platformVersion;
        private S3Location platformDefinitionBundle;
        private String environmentName;
        private List<ConfigurationOptionSetting> optionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformVersionRequest model) {
            this.platformName(model.platformName);
            this.platformVersion(model.platformVersion);
            this.platformDefinitionBundle(model.platformDefinitionBundle);
            this.environmentName(model.environmentName);
            this.optionSettings(model.optionSettings);
        }

        public final String getPlatformName() {
            return this.platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final S3Location.Builder getPlatformDefinitionBundle() {
            return this.platformDefinitionBundle != null ? this.platformDefinitionBundle.toBuilder() : null;
        }

        @Override
        public final Builder platformDefinitionBundle(S3Location platformDefinitionBundle) {
            this.platformDefinitionBundle = platformDefinitionBundle;
            return this;
        }

        public final void setPlatformDefinitionBundle(S3Location.BuilderImpl platformDefinitionBundle) {
            this.platformDefinitionBundle = platformDefinitionBundle != null ? platformDefinitionBundle.build() : null;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final Collection<ConfigurationOptionSetting.Builder> getOptionSettings() {
            return this.optionSettings != null ? (Collection)this.optionSettings.stream().map(ConfigurationOptionSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copyFromBuilder(optionSettings);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreatePlatformVersionRequest build() {
            return new CreatePlatformVersionRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, CreatePlatformVersionRequest> {
        public Builder platformName(String var1);

        public Builder platformVersion(String var1);

        public Builder platformDefinitionBundle(S3Location var1);

        default public Builder platformDefinitionBundle(Consumer<S3Location.Builder> platformDefinitionBundle) {
            return this.platformDefinitionBundle((S3Location)((S3Location.Builder)S3Location.builder().apply(platformDefinitionBundle)).build());
        }

        public Builder environmentName(String var1);

        public Builder optionSettings(Collection<ConfigurationOptionSetting> var1);

        public Builder optionSettings(ConfigurationOptionSetting ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

