/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest;

public class DescribeEnvironmentManagedActionsRequestMarshaller
implements Marshaller<Request<DescribeEnvironmentManagedActionsRequest>, DescribeEnvironmentManagedActionsRequest> {
    public Request<DescribeEnvironmentManagedActionsRequest> marshall(DescribeEnvironmentManagedActionsRequest describeEnvironmentManagedActionsRequest) {
        if (describeEnvironmentManagedActionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEnvironmentManagedActionsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeEnvironmentManagedActions");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEnvironmentManagedActionsRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)describeEnvironmentManagedActionsRequest.environmentName()));
        }
        if (describeEnvironmentManagedActionsRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)describeEnvironmentManagedActionsRequest.environmentId()));
        }
        if (describeEnvironmentManagedActionsRequest.statusString() != null) {
            request.addParameter("Status", StringUtils.fromString((String)describeEnvironmentManagedActionsRequest.statusString()));
        }
        return request;
    }
}

