/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescription;

public class EnvironmentInfoDescriptionUnmarshaller
implements Unmarshaller<EnvironmentInfoDescription, StaxUnmarshallerContext> {
    private static final EnvironmentInfoDescriptionUnmarshaller INSTANCE = new EnvironmentInfoDescriptionUnmarshaller();

    public EnvironmentInfoDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        EnvironmentInfoDescription.Builder environmentInfoDescription = EnvironmentInfoDescription.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("InfoType", targetDepth)) {
                    environmentInfoDescription.infoType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Ec2InstanceId", targetDepth)) {
                    environmentInfoDescription.ec2InstanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SampleTimestamp", targetDepth)) {
                    environmentInfoDescription.sampleTimestamp(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Message", targetDepth)) continue;
                environmentInfoDescription.message(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (EnvironmentInfoDescription)environmentInfoDescription.build();
    }

    public static EnvironmentInfoDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

