/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.DeletePlatformVersionRequest;

public class DeletePlatformVersionRequestMarshaller
implements Marshaller<Request<DeletePlatformVersionRequest>, DeletePlatformVersionRequest> {
    public Request<DeletePlatformVersionRequest> marshall(DeletePlatformVersionRequest deletePlatformVersionRequest) {
        if (deletePlatformVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deletePlatformVersionRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DeletePlatformVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deletePlatformVersionRequest.platformArn() != null) {
            request.addParameter("PlatformArn", StringUtils.fromString((String)deletePlatformVersionRequest.platformArn()));
        }
        return request;
    }
}

