/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnvironmentLink
implements ToCopyableBuilder<Builder, EnvironmentLink> {
    private final String linkName;
    private final String environmentName;

    private EnvironmentLink(BuilderImpl builder) {
        this.linkName = builder.linkName;
        this.environmentName = builder.environmentName;
    }

    public String linkName() {
        return this.linkName;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.linkName() == null ? 0 : this.linkName().hashCode());
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentLink)) {
            return false;
        }
        EnvironmentLink other = (EnvironmentLink)obj;
        if (other.linkName() == null ^ this.linkName() == null) {
            return false;
        }
        if (other.linkName() != null && !other.linkName().equals(this.linkName())) {
            return false;
        }
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        return other.environmentName() == null || other.environmentName().equals(this.environmentName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.linkName() != null) {
            sb.append("LinkName: ").append(this.linkName()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LinkName": {
                return Optional.of(clazz.cast(this.linkName()));
            }
            case "EnvironmentName": {
                return Optional.of(clazz.cast(this.environmentName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String linkName;
        private String environmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentLink model) {
            this.linkName(model.linkName);
            this.environmentName(model.environmentName);
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public EnvironmentLink build() {
            return new EnvironmentLink(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentLink> {
        public Builder linkName(String var1);

        public Builder environmentName(String var1);
    }
}

