/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteApplicationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteApplicationRequest> {
    private final String applicationName;
    private final Boolean terminateEnvByForce;

    private DeleteApplicationRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.terminateEnvByForce = builder.terminateEnvByForce;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Boolean terminateEnvByForce() {
        return this.terminateEnvByForce;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.terminateEnvByForce() == null ? 0 : this.terminateEnvByForce().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationRequest)) {
            return false;
        }
        DeleteApplicationRequest other = (DeleteApplicationRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.terminateEnvByForce() == null ^ this.terminateEnvByForce() == null) {
            return false;
        }
        return other.terminateEnvByForce() == null || other.terminateEnvByForce().equals(this.terminateEnvByForce());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.terminateEnvByForce() != null) {
            sb.append("TerminateEnvByForce: ").append(this.terminateEnvByForce()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "TerminateEnvByForce": {
                return Optional.of(clazz.cast(this.terminateEnvByForce()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private Boolean terminateEnvByForce;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationRequest model) {
            this.applicationName(model.applicationName);
            this.terminateEnvByForce(model.terminateEnvByForce);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Boolean getTerminateEnvByForce() {
            return this.terminateEnvByForce;
        }

        @Override
        public final Builder terminateEnvByForce(Boolean terminateEnvByForce) {
            this.terminateEnvByForce = terminateEnvByForce;
            return this;
        }

        public final void setTerminateEnvByForce(Boolean terminateEnvByForce) {
            this.terminateEnvByForce = terminateEnvByForce;
        }

        public DeleteApplicationRequest build() {
            return new DeleteApplicationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder terminateEnvByForce(Boolean var1);
    }
}

