/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentDescriptionsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComposeEnvironmentsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ComposeEnvironmentsResponse> {
    private final List<EnvironmentDescription> environments;

    private ComposeEnvironmentsResponse(BuilderImpl builder) {
        this.environments = builder.environments;
    }

    public List<EnvironmentDescription> environments() {
        return this.environments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.environments() == null ? 0 : this.environments().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComposeEnvironmentsResponse)) {
            return false;
        }
        ComposeEnvironmentsResponse other = (ComposeEnvironmentsResponse)((Object)obj);
        if (other.environments() == null ^ this.environments() == null) {
            return false;
        }
        return other.environments() == null || other.environments().equals(this.environments());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.environments() != null) {
            sb.append("Environments: ").append(this.environments()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Environments": {
                return Optional.of(clazz.cast(this.environments()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<EnvironmentDescription> environments;

        private BuilderImpl() {
        }

        private BuilderImpl(ComposeEnvironmentsResponse model) {
            this.environments(model.environments);
        }

        public final Collection<EnvironmentDescription.Builder> getEnvironments() {
            return this.environments != null ? (Collection)this.environments.stream().map(EnvironmentDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environments(Collection<EnvironmentDescription> environments) {
            this.environments = EnvironmentDescriptionsListCopier.copy(environments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(EnvironmentDescription ... environments) {
            this.environments(Arrays.asList(environments));
            return this;
        }

        public final void setEnvironments(Collection<EnvironmentDescription.BuilderImpl> environments) {
            this.environments = EnvironmentDescriptionsListCopier.copyFromBuilder(environments);
        }

        public ComposeEnvironmentsResponse build() {
            return new ComposeEnvironmentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComposeEnvironmentsResponse> {
        public Builder environments(Collection<EnvironmentDescription> var1);

        public Builder environments(EnvironmentDescription ... var1);
    }
}

