/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TerminateEnvironmentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, TerminateEnvironmentRequest> {
    private final String environmentId;
    private final String environmentName;
    private final Boolean terminateResources;
    private final Boolean forceTerminate;

    private TerminateEnvironmentRequest(BuilderImpl builder) {
        this.environmentId = builder.environmentId;
        this.environmentName = builder.environmentName;
        this.terminateResources = builder.terminateResources;
        this.forceTerminate = builder.forceTerminate;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public Boolean terminateResources() {
        return this.terminateResources;
    }

    public Boolean forceTerminate() {
        return this.forceTerminate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.environmentId() == null ? 0 : this.environmentId().hashCode());
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        hashCode = 31 * hashCode + (this.terminateResources() == null ? 0 : this.terminateResources().hashCode());
        hashCode = 31 * hashCode + (this.forceTerminate() == null ? 0 : this.forceTerminate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateEnvironmentRequest)) {
            return false;
        }
        TerminateEnvironmentRequest other = (TerminateEnvironmentRequest)((Object)obj);
        if (other.environmentId() == null ^ this.environmentId() == null) {
            return false;
        }
        if (other.environmentId() != null && !other.environmentId().equals(this.environmentId())) {
            return false;
        }
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        if (other.environmentName() != null && !other.environmentName().equals(this.environmentName())) {
            return false;
        }
        if (other.terminateResources() == null ^ this.terminateResources() == null) {
            return false;
        }
        if (other.terminateResources() != null && !other.terminateResources().equals(this.terminateResources())) {
            return false;
        }
        if (other.forceTerminate() == null ^ this.forceTerminate() == null) {
            return false;
        }
        return other.forceTerminate() == null || other.forceTerminate().equals(this.forceTerminate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.environmentId() != null) {
            sb.append("EnvironmentId: ").append(this.environmentId()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.terminateResources() != null) {
            sb.append("TerminateResources: ").append(this.terminateResources()).append(",");
        }
        if (this.forceTerminate() != null) {
            sb.append("ForceTerminate: ").append(this.forceTerminate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String environmentId;
        private String environmentName;
        private Boolean terminateResources;
        private Boolean forceTerminate;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateEnvironmentRequest model) {
            this.setEnvironmentId(model.environmentId);
            this.setEnvironmentName(model.environmentName);
            this.setTerminateResources(model.terminateResources);
            this.setForceTerminate(model.forceTerminate);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final Boolean getTerminateResources() {
            return this.terminateResources;
        }

        @Override
        public final Builder terminateResources(Boolean terminateResources) {
            this.terminateResources = terminateResources;
            return this;
        }

        public final void setTerminateResources(Boolean terminateResources) {
            this.terminateResources = terminateResources;
        }

        public final Boolean getForceTerminate() {
            return this.forceTerminate;
        }

        @Override
        public final Builder forceTerminate(Boolean forceTerminate) {
            this.forceTerminate = forceTerminate;
            return this;
        }

        public final void setForceTerminate(Boolean forceTerminate) {
            this.forceTerminate = forceTerminate;
        }

        public TerminateEnvironmentRequest build() {
            return new TerminateEnvironmentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TerminateEnvironmentRequest> {
        public Builder environmentId(String var1);

        public Builder environmentName(String var1);

        public Builder terminateResources(Boolean var1);

        public Builder forceTerminate(Boolean var1);
    }
}

