/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.InstanceHealthListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.SingleInstanceHealth;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstancesHealthResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInstancesHealthResponse> {
    private final List<SingleInstanceHealth> instanceHealthList;
    private final Instant refreshedAt;
    private final String nextToken;

    private DescribeInstancesHealthResponse(BuilderImpl builder) {
        this.instanceHealthList = builder.instanceHealthList;
        this.refreshedAt = builder.refreshedAt;
        this.nextToken = builder.nextToken;
    }

    public List<SingleInstanceHealth> instanceHealthList() {
        return this.instanceHealthList;
    }

    public Instant refreshedAt() {
        return this.refreshedAt;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceHealthList() == null ? 0 : this.instanceHealthList().hashCode());
        hashCode = 31 * hashCode + (this.refreshedAt() == null ? 0 : this.refreshedAt().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesHealthResponse)) {
            return false;
        }
        DescribeInstancesHealthResponse other = (DescribeInstancesHealthResponse)((Object)obj);
        if (other.instanceHealthList() == null ^ this.instanceHealthList() == null) {
            return false;
        }
        if (other.instanceHealthList() != null && !other.instanceHealthList().equals(this.instanceHealthList())) {
            return false;
        }
        if (other.refreshedAt() == null ^ this.refreshedAt() == null) {
            return false;
        }
        if (other.refreshedAt() != null && !other.refreshedAt().equals(this.refreshedAt())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceHealthList() != null) {
            sb.append("InstanceHealthList: ").append(this.instanceHealthList()).append(",");
        }
        if (this.refreshedAt() != null) {
            sb.append("RefreshedAt: ").append(this.refreshedAt()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<SingleInstanceHealth> instanceHealthList;
        private Instant refreshedAt;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesHealthResponse model) {
            this.setInstanceHealthList(model.instanceHealthList);
            this.setRefreshedAt(model.refreshedAt);
            this.setNextToken(model.nextToken);
        }

        public final Collection<SingleInstanceHealth> getInstanceHealthList() {
            return this.instanceHealthList;
        }

        @Override
        public final Builder instanceHealthList(Collection<SingleInstanceHealth> instanceHealthList) {
            this.instanceHealthList = InstanceHealthListCopier.copy(instanceHealthList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceHealthList(SingleInstanceHealth ... instanceHealthList) {
            this.instanceHealthList(Arrays.asList(instanceHealthList));
            return this;
        }

        public final void setInstanceHealthList(Collection<SingleInstanceHealth> instanceHealthList) {
            this.instanceHealthList = InstanceHealthListCopier.copy(instanceHealthList);
        }

        public final Instant getRefreshedAt() {
            return this.refreshedAt;
        }

        @Override
        public final Builder refreshedAt(Instant refreshedAt) {
            this.refreshedAt = refreshedAt;
            return this;
        }

        public final void setRefreshedAt(Instant refreshedAt) {
            this.refreshedAt = refreshedAt;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeInstancesHealthResponse build() {
            return new DescribeInstancesHealthResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstancesHealthResponse> {
        public Builder instanceHealthList(Collection<SingleInstanceHealth> var1);

        public Builder instanceHealthList(SingleInstanceHealth ... var1);

        public Builder refreshedAt(Instant var1);

        public Builder nextToken(String var1);
    }
}

