/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescriptionsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeConfigurationOptionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeConfigurationOptionsResponse> {
    private final String solutionStackName;
    private final String platformArn;
    private final List<ConfigurationOptionDescription> options;

    private DescribeConfigurationOptionsResponse(BuilderImpl builder) {
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.options = builder.options;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public List<ConfigurationOptionDescription> options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.solutionStackName() == null ? 0 : this.solutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.platformArn() == null ? 0 : this.platformArn().hashCode());
        hashCode = 31 * hashCode + (this.options() == null ? 0 : this.options().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationOptionsResponse)) {
            return false;
        }
        DescribeConfigurationOptionsResponse other = (DescribeConfigurationOptionsResponse)((Object)obj);
        if (other.solutionStackName() == null ^ this.solutionStackName() == null) {
            return false;
        }
        if (other.solutionStackName() != null && !other.solutionStackName().equals(this.solutionStackName())) {
            return false;
        }
        if (other.platformArn() == null ^ this.platformArn() == null) {
            return false;
        }
        if (other.platformArn() != null && !other.platformArn().equals(this.platformArn())) {
            return false;
        }
        if (other.options() == null ^ this.options() == null) {
            return false;
        }
        return other.options() == null || other.options().equals(this.options());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.solutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.solutionStackName()).append(",");
        }
        if (this.platformArn() != null) {
            sb.append("PlatformArn: ").append(this.platformArn()).append(",");
        }
        if (this.options() != null) {
            sb.append("Options: ").append(this.options()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String solutionStackName;
        private String platformArn;
        private List<ConfigurationOptionDescription> options;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationOptionsResponse model) {
            this.setSolutionStackName(model.solutionStackName);
            this.setPlatformArn(model.platformArn);
            this.setOptions(model.options);
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final Collection<ConfigurationOptionDescription> getOptions() {
            return this.options;
        }

        @Override
        public final Builder options(Collection<ConfigurationOptionDescription> options) {
            this.options = ConfigurationOptionDescriptionsListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(ConfigurationOptionDescription ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        public final void setOptions(Collection<ConfigurationOptionDescription> options) {
            this.options = ConfigurationOptionDescriptionsListCopier.copy(options);
        }

        public DescribeConfigurationOptionsResponse build() {
            return new DescribeConfigurationOptionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeConfigurationOptionsResponse> {
        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder options(Collection<ConfigurationOptionDescription> var1);

        public Builder options(ConfigurationOptionDescription ... var1);
    }
}

