/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSettingsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.S3Location;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePlatformVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreatePlatformVersionRequest> {
    private final String platformName;
    private final String platformVersion;
    private final S3Location platformDefinitionBundle;
    private final String environmentName;
    private final List<ConfigurationOptionSetting> optionSettings;

    private CreatePlatformVersionRequest(BuilderImpl builder) {
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.platformDefinitionBundle = builder.platformDefinitionBundle;
        this.environmentName = builder.environmentName;
        this.optionSettings = builder.optionSettings;
    }

    public String platformName() {
        return this.platformName;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public S3Location platformDefinitionBundle() {
        return this.platformDefinitionBundle;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public List<ConfigurationOptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.platformName() == null ? 0 : this.platformName().hashCode());
        hashCode = 31 * hashCode + (this.platformVersion() == null ? 0 : this.platformVersion().hashCode());
        hashCode = 31 * hashCode + (this.platformDefinitionBundle() == null ? 0 : this.platformDefinitionBundle().hashCode());
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        hashCode = 31 * hashCode + (this.optionSettings() == null ? 0 : this.optionSettings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformVersionRequest)) {
            return false;
        }
        CreatePlatformVersionRequest other = (CreatePlatformVersionRequest)((Object)obj);
        if (other.platformName() == null ^ this.platformName() == null) {
            return false;
        }
        if (other.platformName() != null && !other.platformName().equals(this.platformName())) {
            return false;
        }
        if (other.platformVersion() == null ^ this.platformVersion() == null) {
            return false;
        }
        if (other.platformVersion() != null && !other.platformVersion().equals(this.platformVersion())) {
            return false;
        }
        if (other.platformDefinitionBundle() == null ^ this.platformDefinitionBundle() == null) {
            return false;
        }
        if (other.platformDefinitionBundle() != null && !other.platformDefinitionBundle().equals(this.platformDefinitionBundle())) {
            return false;
        }
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        if (other.environmentName() != null && !other.environmentName().equals(this.environmentName())) {
            return false;
        }
        if (other.optionSettings() == null ^ this.optionSettings() == null) {
            return false;
        }
        return other.optionSettings() == null || other.optionSettings().equals(this.optionSettings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.platformName() != null) {
            sb.append("PlatformName: ").append(this.platformName()).append(",");
        }
        if (this.platformVersion() != null) {
            sb.append("PlatformVersion: ").append(this.platformVersion()).append(",");
        }
        if (this.platformDefinitionBundle() != null) {
            sb.append("PlatformDefinitionBundle: ").append(this.platformDefinitionBundle()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.optionSettings() != null) {
            sb.append("OptionSettings: ").append(this.optionSettings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String platformName;
        private String platformVersion;
        private S3Location platformDefinitionBundle;
        private String environmentName;
        private List<ConfigurationOptionSetting> optionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformVersionRequest model) {
            this.setPlatformName(model.platformName);
            this.setPlatformVersion(model.platformVersion);
            this.setPlatformDefinitionBundle(model.platformDefinitionBundle);
            this.setEnvironmentName(model.environmentName);
            this.setOptionSettings(model.optionSettings);
        }

        public final String getPlatformName() {
            return this.platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final S3Location getPlatformDefinitionBundle() {
            return this.platformDefinitionBundle;
        }

        @Override
        public final Builder platformDefinitionBundle(S3Location platformDefinitionBundle) {
            this.platformDefinitionBundle = platformDefinitionBundle;
            return this;
        }

        public final void setPlatformDefinitionBundle(S3Location platformDefinitionBundle) {
            this.platformDefinitionBundle = platformDefinitionBundle;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final Collection<ConfigurationOptionSetting> getOptionSettings() {
            return this.optionSettings;
        }

        @Override
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
        }

        public CreatePlatformVersionRequest build() {
            return new CreatePlatformVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreatePlatformVersionRequest> {
        public Builder platformName(String var1);

        public Builder platformVersion(String var1);

        public Builder platformDefinitionBundle(S3Location var1);

        public Builder environmentName(String var1);

        public Builder optionSettings(Collection<ConfigurationOptionSetting> var1);

        public Builder optionSettings(ConfigurationOptionSetting ... var1);
    }
}

