/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationSettingsDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationSettingsDescriptionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeConfigurationSettingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeConfigurationSettingsResponse> {
    private final List<ConfigurationSettingsDescription> configurationSettings;

    private DescribeConfigurationSettingsResponse(BuilderImpl builder) {
        this.configurationSettings = builder.configurationSettings;
    }

    public List<ConfigurationSettingsDescription> configurationSettings() {
        return this.configurationSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.configurationSettings() == null ? 0 : this.configurationSettings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSettingsResponse)) {
            return false;
        }
        DescribeConfigurationSettingsResponse other = (DescribeConfigurationSettingsResponse)((Object)obj);
        if (other.configurationSettings() == null ^ this.configurationSettings() == null) {
            return false;
        }
        return other.configurationSettings() == null || other.configurationSettings().equals(this.configurationSettings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configurationSettings() != null) {
            sb.append("ConfigurationSettings: ").append(this.configurationSettings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ConfigurationSettingsDescription> configurationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSettingsResponse model) {
            this.setConfigurationSettings(model.configurationSettings);
        }

        public final Collection<ConfigurationSettingsDescription> getConfigurationSettings() {
            return this.configurationSettings;
        }

        @Override
        public final Builder configurationSettings(Collection<ConfigurationSettingsDescription> configurationSettings) {
            this.configurationSettings = ConfigurationSettingsDescriptionListCopier.copy(configurationSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSettings(ConfigurationSettingsDescription ... configurationSettings) {
            this.configurationSettings(Arrays.asList(configurationSettings));
            return this;
        }

        public final void setConfigurationSettings(Collection<ConfigurationSettingsDescription> configurationSettings) {
            this.configurationSettings = ConfigurationSettingsDescriptionListCopier.copy(configurationSettings);
        }

        public DescribeConfigurationSettingsResponse build() {
            return new DescribeConfigurationSettingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeConfigurationSettingsResponse> {
        public Builder configurationSettings(Collection<ConfigurationSettingsDescription> var1);

        public Builder configurationSettings(ConfigurationSettingsDescription ... var1);
    }
}

