/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealth;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentHealthStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentLink;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentLinksCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentResourcesDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentStatus;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateEnvironmentResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateEnvironmentResponse> {
    private final String environmentName;
    private final String environmentId;
    private final String applicationName;
    private final String versionLabel;
    private final String solutionStackName;
    private final String platformArn;
    private final String templateName;
    private final String description;
    private final String endpointURL;
    private final String cname;
    private final Instant dateCreated;
    private final Instant dateUpdated;
    private final String status;
    private final Boolean abortableOperationInProgress;
    private final String health;
    private final String healthStatus;
    private final EnvironmentResourcesDescription resources;
    private final EnvironmentTier tier;
    private final List<EnvironmentLink> environmentLinks;

    private CreateEnvironmentResponse(BuilderImpl builder) {
        this.environmentName = builder.environmentName;
        this.environmentId = builder.environmentId;
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.endpointURL = builder.endpointURL;
        this.cname = builder.cname;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.status = builder.status;
        this.abortableOperationInProgress = builder.abortableOperationInProgress;
        this.health = builder.health;
        this.healthStatus = builder.healthStatus;
        this.resources = builder.resources;
        this.tier = builder.tier;
        this.environmentLinks = builder.environmentLinks;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public String templateName() {
        return this.templateName;
    }

    public String description() {
        return this.description;
    }

    public String endpointURL() {
        return this.endpointURL;
    }

    public String cname() {
        return this.cname;
    }

    public Instant dateCreated() {
        return this.dateCreated;
    }

    public Instant dateUpdated() {
        return this.dateUpdated;
    }

    public String status() {
        return this.status;
    }

    public Boolean abortableOperationInProgress() {
        return this.abortableOperationInProgress;
    }

    public String health() {
        return this.health;
    }

    public String healthStatus() {
        return this.healthStatus;
    }

    public EnvironmentResourcesDescription resources() {
        return this.resources;
    }

    public EnvironmentTier tier() {
        return this.tier;
    }

    public List<EnvironmentLink> environmentLinks() {
        return this.environmentLinks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        hashCode = 31 * hashCode + (this.environmentId() == null ? 0 : this.environmentId().hashCode());
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.versionLabel() == null ? 0 : this.versionLabel().hashCode());
        hashCode = 31 * hashCode + (this.solutionStackName() == null ? 0 : this.solutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.platformArn() == null ? 0 : this.platformArn().hashCode());
        hashCode = 31 * hashCode + (this.templateName() == null ? 0 : this.templateName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.endpointURL() == null ? 0 : this.endpointURL().hashCode());
        hashCode = 31 * hashCode + (this.cname() == null ? 0 : this.cname().hashCode());
        hashCode = 31 * hashCode + (this.dateCreated() == null ? 0 : this.dateCreated().hashCode());
        hashCode = 31 * hashCode + (this.dateUpdated() == null ? 0 : this.dateUpdated().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.abortableOperationInProgress() == null ? 0 : this.abortableOperationInProgress().hashCode());
        hashCode = 31 * hashCode + (this.health() == null ? 0 : this.health().hashCode());
        hashCode = 31 * hashCode + (this.healthStatus() == null ? 0 : this.healthStatus().hashCode());
        hashCode = 31 * hashCode + (this.resources() == null ? 0 : this.resources().hashCode());
        hashCode = 31 * hashCode + (this.tier() == null ? 0 : this.tier().hashCode());
        hashCode = 31 * hashCode + (this.environmentLinks() == null ? 0 : this.environmentLinks().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentResponse)) {
            return false;
        }
        CreateEnvironmentResponse other = (CreateEnvironmentResponse)((Object)obj);
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        if (other.environmentName() != null && !other.environmentName().equals(this.environmentName())) {
            return false;
        }
        if (other.environmentId() == null ^ this.environmentId() == null) {
            return false;
        }
        if (other.environmentId() != null && !other.environmentId().equals(this.environmentId())) {
            return false;
        }
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.versionLabel() == null ^ this.versionLabel() == null) {
            return false;
        }
        if (other.versionLabel() != null && !other.versionLabel().equals(this.versionLabel())) {
            return false;
        }
        if (other.solutionStackName() == null ^ this.solutionStackName() == null) {
            return false;
        }
        if (other.solutionStackName() != null && !other.solutionStackName().equals(this.solutionStackName())) {
            return false;
        }
        if (other.platformArn() == null ^ this.platformArn() == null) {
            return false;
        }
        if (other.platformArn() != null && !other.platformArn().equals(this.platformArn())) {
            return false;
        }
        if (other.templateName() == null ^ this.templateName() == null) {
            return false;
        }
        if (other.templateName() != null && !other.templateName().equals(this.templateName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.endpointURL() == null ^ this.endpointURL() == null) {
            return false;
        }
        if (other.endpointURL() != null && !other.endpointURL().equals(this.endpointURL())) {
            return false;
        }
        if (other.cname() == null ^ this.cname() == null) {
            return false;
        }
        if (other.cname() != null && !other.cname().equals(this.cname())) {
            return false;
        }
        if (other.dateCreated() == null ^ this.dateCreated() == null) {
            return false;
        }
        if (other.dateCreated() != null && !other.dateCreated().equals(this.dateCreated())) {
            return false;
        }
        if (other.dateUpdated() == null ^ this.dateUpdated() == null) {
            return false;
        }
        if (other.dateUpdated() != null && !other.dateUpdated().equals(this.dateUpdated())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.abortableOperationInProgress() == null ^ this.abortableOperationInProgress() == null) {
            return false;
        }
        if (other.abortableOperationInProgress() != null && !other.abortableOperationInProgress().equals(this.abortableOperationInProgress())) {
            return false;
        }
        if (other.health() == null ^ this.health() == null) {
            return false;
        }
        if (other.health() != null && !other.health().equals(this.health())) {
            return false;
        }
        if (other.healthStatus() == null ^ this.healthStatus() == null) {
            return false;
        }
        if (other.healthStatus() != null && !other.healthStatus().equals(this.healthStatus())) {
            return false;
        }
        if (other.resources() == null ^ this.resources() == null) {
            return false;
        }
        if (other.resources() != null && !other.resources().equals(this.resources())) {
            return false;
        }
        if (other.tier() == null ^ this.tier() == null) {
            return false;
        }
        if (other.tier() != null && !other.tier().equals(this.tier())) {
            return false;
        }
        if (other.environmentLinks() == null ^ this.environmentLinks() == null) {
            return false;
        }
        return other.environmentLinks() == null || other.environmentLinks().equals(this.environmentLinks());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.environmentId() != null) {
            sb.append("EnvironmentId: ").append(this.environmentId()).append(",");
        }
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.versionLabel() != null) {
            sb.append("VersionLabel: ").append(this.versionLabel()).append(",");
        }
        if (this.solutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.solutionStackName()).append(",");
        }
        if (this.platformArn() != null) {
            sb.append("PlatformArn: ").append(this.platformArn()).append(",");
        }
        if (this.templateName() != null) {
            sb.append("TemplateName: ").append(this.templateName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.endpointURL() != null) {
            sb.append("EndpointURL: ").append(this.endpointURL()).append(",");
        }
        if (this.cname() != null) {
            sb.append("CNAME: ").append(this.cname()).append(",");
        }
        if (this.dateCreated() != null) {
            sb.append("DateCreated: ").append(this.dateCreated()).append(",");
        }
        if (this.dateUpdated() != null) {
            sb.append("DateUpdated: ").append(this.dateUpdated()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.abortableOperationInProgress() != null) {
            sb.append("AbortableOperationInProgress: ").append(this.abortableOperationInProgress()).append(",");
        }
        if (this.health() != null) {
            sb.append("Health: ").append(this.health()).append(",");
        }
        if (this.healthStatus() != null) {
            sb.append("HealthStatus: ").append(this.healthStatus()).append(",");
        }
        if (this.resources() != null) {
            sb.append("Resources: ").append(this.resources()).append(",");
        }
        if (this.tier() != null) {
            sb.append("Tier: ").append(this.tier()).append(",");
        }
        if (this.environmentLinks() != null) {
            sb.append("EnvironmentLinks: ").append(this.environmentLinks()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String environmentName;
        private String environmentId;
        private String applicationName;
        private String versionLabel;
        private String solutionStackName;
        private String platformArn;
        private String templateName;
        private String description;
        private String endpointURL;
        private String cname;
        private Instant dateCreated;
        private Instant dateUpdated;
        private String status;
        private Boolean abortableOperationInProgress;
        private String health;
        private String healthStatus;
        private EnvironmentResourcesDescription resources;
        private EnvironmentTier tier;
        private List<EnvironmentLink> environmentLinks;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentResponse model) {
            this.setEnvironmentName(model.environmentName);
            this.setEnvironmentId(model.environmentId);
            this.setApplicationName(model.applicationName);
            this.setVersionLabel(model.versionLabel);
            this.setSolutionStackName(model.solutionStackName);
            this.setPlatformArn(model.platformArn);
            this.setTemplateName(model.templateName);
            this.setDescription(model.description);
            this.setEndpointURL(model.endpointURL);
            this.setCNAME(model.cname);
            this.setDateCreated(model.dateCreated);
            this.setDateUpdated(model.dateUpdated);
            this.setStatus(model.status);
            this.setAbortableOperationInProgress(model.abortableOperationInProgress);
            this.setHealth(model.health);
            this.setHealthStatus(model.healthStatus);
            this.setResources(model.resources);
            this.setTier(model.tier);
            this.setEnvironmentLinks(model.environmentLinks);
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEndpointURL() {
            return this.endpointURL;
        }

        @Override
        public final Builder endpointURL(String endpointURL) {
            this.endpointURL = endpointURL;
            return this;
        }

        public final void setEndpointURL(String endpointURL) {
            this.endpointURL = endpointURL;
        }

        public final String getCNAME() {
            return this.cname;
        }

        @Override
        public final Builder cname(String cname) {
            this.cname = cname;
            return this;
        }

        public final void setCNAME(String cname) {
            this.cname = cname;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getDateUpdated() {
            return this.dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(Instant dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Boolean getAbortableOperationInProgress() {
            return this.abortableOperationInProgress;
        }

        @Override
        public final Builder abortableOperationInProgress(Boolean abortableOperationInProgress) {
            this.abortableOperationInProgress = abortableOperationInProgress;
            return this;
        }

        public final void setAbortableOperationInProgress(Boolean abortableOperationInProgress) {
            this.abortableOperationInProgress = abortableOperationInProgress;
        }

        public final String getHealth() {
            return this.health;
        }

        @Override
        public final Builder health(String health) {
            this.health = health;
            return this;
        }

        @Override
        public final Builder health(EnvironmentHealth health) {
            this.health(health.toString());
            return this;
        }

        public final void setHealth(String health) {
            this.health = health;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(EnvironmentHealthStatus healthStatus) {
            this.healthStatus(healthStatus.toString());
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final EnvironmentResourcesDescription getResources() {
            return this.resources;
        }

        @Override
        public final Builder resources(EnvironmentResourcesDescription resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(EnvironmentResourcesDescription resources) {
            this.resources = resources;
        }

        public final EnvironmentTier getTier() {
            return this.tier;
        }

        @Override
        public final Builder tier(EnvironmentTier tier) {
            this.tier = tier;
            return this;
        }

        public final void setTier(EnvironmentTier tier) {
            this.tier = tier;
        }

        public final Collection<EnvironmentLink> getEnvironmentLinks() {
            return this.environmentLinks;
        }

        @Override
        public final Builder environmentLinks(Collection<EnvironmentLink> environmentLinks) {
            this.environmentLinks = EnvironmentLinksCopier.copy(environmentLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentLinks(EnvironmentLink ... environmentLinks) {
            this.environmentLinks(Arrays.asList(environmentLinks));
            return this;
        }

        public final void setEnvironmentLinks(Collection<EnvironmentLink> environmentLinks) {
            this.environmentLinks = EnvironmentLinksCopier.copy(environmentLinks);
        }

        public CreateEnvironmentResponse build() {
            return new CreateEnvironmentResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateEnvironmentResponse> {
        public Builder environmentName(String var1);

        public Builder environmentId(String var1);

        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder templateName(String var1);

        public Builder description(String var1);

        public Builder endpointURL(String var1);

        public Builder cname(String var1);

        public Builder dateCreated(Instant var1);

        public Builder dateUpdated(Instant var1);

        public Builder status(String var1);

        public Builder status(EnvironmentStatus var1);

        public Builder abortableOperationInProgress(Boolean var1);

        public Builder health(String var1);

        public Builder health(EnvironmentHealth var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(EnvironmentHealthStatus var1);

        public Builder resources(EnvironmentResourcesDescription var1);

        public Builder tier(EnvironmentTier var1);

        public Builder environmentLinks(Collection<EnvironmentLink> var1);

        public Builder environmentLinks(EnvironmentLink ... var1);
    }
}

