/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.StatusCodes;

public class StatusCodesUnmarshaller
implements Unmarshaller<StatusCodes, StaxUnmarshallerContext> {
    private static StatusCodesUnmarshaller INSTANCE;

    public StatusCodes unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        StatusCodes.Builder statusCodes = StatusCodes.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Status2xx", targetDepth)) {
                    statusCodes.status2xx(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status3xx", targetDepth)) {
                    statusCodes.status3xx(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status4xx", targetDepth)) {
                    statusCodes.status4xx(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Status5xx", targetDepth)) continue;
                statusCodes.status5xx(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (StatusCodes)statusCodes.build();
    }

    public static StatusCodesUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StatusCodesUnmarshaller();
        }
        return INSTANCE;
    }
}

