/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationDescription;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ApplicationResourceLifecycleConfigUnmarshaller;

public class ApplicationDescriptionUnmarshaller
implements Unmarshaller<ApplicationDescription, StaxUnmarshallerContext> {
    private static ApplicationDescriptionUnmarshaller INSTANCE;

    public ApplicationDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        ApplicationDescription.Builder applicationDescription;
        block12: {
            applicationDescription = ApplicationDescription.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> versions = null;
            ArrayList<String> configurationTemplates = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    applicationDescription.versions(versions);
                    applicationDescription.configurationTemplates(configurationTemplates);
                    break block12;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("ApplicationName", targetDepth)) {
                        applicationDescription.applicationName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Description", targetDepth)) {
                        applicationDescription.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DateCreated", targetDepth)) {
                        applicationDescription.dateCreated(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DateUpdated", targetDepth)) {
                        applicationDescription.dateUpdated(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Versions", targetDepth)) {
                        versions = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("Versions/member", targetDepth)) {
                        versions.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ConfigurationTemplates", targetDepth)) {
                        configurationTemplates = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("ConfigurationTemplates/member", targetDepth)) {
                        configurationTemplates.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("ResourceLifecycleConfig", targetDepth)) continue;
                    applicationDescription.resourceLifecycleConfig(ApplicationResourceLifecycleConfigUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            applicationDescription.versions(versions);
            applicationDescription.configurationTemplates(configurationTemplates);
        }
        return (ApplicationDescription)applicationDescription.build();
    }

    public static ApplicationDescriptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ApplicationDescriptionUnmarshaller();
        }
        return INSTANCE;
    }
}

