/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSettingsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionsSpecifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateConfigurationTemplateRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateConfigurationTemplateRequest> {
    private final String applicationName;
    private final String templateName;
    private final String description;
    private final List<ConfigurationOptionSetting> optionSettings;
    private final List<OptionSpecification> optionsToRemove;

    private UpdateConfigurationTemplateRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.optionSettings = builder.optionSettings;
        this.optionsToRemove = builder.optionsToRemove;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String templateName() {
        return this.templateName;
    }

    public String description() {
        return this.description;
    }

    public List<ConfigurationOptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public List<OptionSpecification> optionsToRemove() {
        return this.optionsToRemove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.templateName() == null ? 0 : this.templateName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.optionSettings() == null ? 0 : this.optionSettings().hashCode());
        hashCode = 31 * hashCode + (this.optionsToRemove() == null ? 0 : this.optionsToRemove().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationTemplateRequest)) {
            return false;
        }
        UpdateConfigurationTemplateRequest other = (UpdateConfigurationTemplateRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.templateName() == null ^ this.templateName() == null) {
            return false;
        }
        if (other.templateName() != null && !other.templateName().equals(this.templateName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.optionSettings() == null ^ this.optionSettings() == null) {
            return false;
        }
        if (other.optionSettings() != null && !other.optionSettings().equals(this.optionSettings())) {
            return false;
        }
        if (other.optionsToRemove() == null ^ this.optionsToRemove() == null) {
            return false;
        }
        return other.optionsToRemove() == null || other.optionsToRemove().equals(this.optionsToRemove());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.templateName() != null) {
            sb.append("TemplateName: ").append(this.templateName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.optionSettings() != null) {
            sb.append("OptionSettings: ").append(this.optionSettings()).append(",");
        }
        if (this.optionsToRemove() != null) {
            sb.append("OptionsToRemove: ").append(this.optionsToRemove()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String templateName;
        private String description;
        private List<ConfigurationOptionSetting> optionSettings;
        private List<OptionSpecification> optionsToRemove;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationTemplateRequest model) {
            this.setApplicationName(model.applicationName);
            this.setTemplateName(model.templateName);
            this.setDescription(model.description);
            this.setOptionSettings(model.optionSettings);
            this.setOptionsToRemove(model.optionsToRemove);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<ConfigurationOptionSetting> getOptionSettings() {
            return this.optionSettings;
        }

        @Override
        public final Builder optionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(ConfigurationOptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        public final void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
            this.optionSettings = ConfigurationOptionSettingsListCopier.copy(optionSettings);
        }

        @SafeVarargs
        public final void setOptionSettings(ConfigurationOptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
        }

        public final Collection<OptionSpecification> getOptionsToRemove() {
            return this.optionsToRemove;
        }

        @Override
        public final Builder optionsToRemove(Collection<OptionSpecification> optionsToRemove) {
            this.optionsToRemove = OptionsSpecifierListCopier.copy(optionsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsToRemove(OptionSpecification ... optionsToRemove) {
            this.optionsToRemove(Arrays.asList(optionsToRemove));
            return this;
        }

        public final void setOptionsToRemove(Collection<OptionSpecification> optionsToRemove) {
            this.optionsToRemove = OptionsSpecifierListCopier.copy(optionsToRemove);
        }

        @SafeVarargs
        public final void setOptionsToRemove(OptionSpecification ... optionsToRemove) {
            this.optionsToRemove(Arrays.asList(optionsToRemove));
        }

        public UpdateConfigurationTemplateRequest build() {
            return new UpdateConfigurationTemplateRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateConfigurationTemplateRequest> {
        public Builder applicationName(String var1);

        public Builder templateName(String var1);

        public Builder description(String var1);

        public Builder optionSettings(Collection<ConfigurationOptionSetting> var1);

        public Builder optionSettings(ConfigurationOptionSetting ... var1);

        public Builder optionsToRemove(Collection<OptionSpecification> var1);

        public Builder optionsToRemove(OptionSpecification ... var1);
    }
}

