/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticbeanstalk.model.CPUUtilization;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadAverageCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SystemStatus
implements ToCopyableBuilder<Builder, SystemStatus> {
    private final CPUUtilization cpuUtilization;
    private final List<Double> loadAverage;

    private SystemStatus(BuilderImpl builder) {
        this.cpuUtilization = builder.cpuUtilization;
        this.loadAverage = builder.loadAverage;
    }

    public CPUUtilization cpuUtilization() {
        return this.cpuUtilization;
    }

    public List<Double> loadAverage() {
        return this.loadAverage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cpuUtilization() == null ? 0 : this.cpuUtilization().hashCode());
        hashCode = 31 * hashCode + (this.loadAverage() == null ? 0 : this.loadAverage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemStatus)) {
            return false;
        }
        SystemStatus other = (SystemStatus)obj;
        if (other.cpuUtilization() == null ^ this.cpuUtilization() == null) {
            return false;
        }
        if (other.cpuUtilization() != null && !other.cpuUtilization().equals(this.cpuUtilization())) {
            return false;
        }
        if (other.loadAverage() == null ^ this.loadAverage() == null) {
            return false;
        }
        return other.loadAverage() == null || other.loadAverage().equals(this.loadAverage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cpuUtilization() != null) {
            sb.append("CPUUtilization: ").append(this.cpuUtilization()).append(",");
        }
        if (this.loadAverage() != null) {
            sb.append("LoadAverage: ").append(this.loadAverage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private CPUUtilization cpuUtilization;
        private List<Double> loadAverage;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemStatus model) {
            this.setCPUUtilization(model.cpuUtilization);
            this.setLoadAverage(model.loadAverage);
        }

        public final CPUUtilization getCPUUtilization() {
            return this.cpuUtilization;
        }

        @Override
        public final Builder cpuUtilization(CPUUtilization cpuUtilization) {
            this.cpuUtilization = cpuUtilization;
            return this;
        }

        public final void setCPUUtilization(CPUUtilization cpuUtilization) {
            this.cpuUtilization = cpuUtilization;
        }

        public final Collection<Double> getLoadAverage() {
            return this.loadAverage;
        }

        @Override
        public final Builder loadAverage(Collection<Double> loadAverage) {
            this.loadAverage = LoadAverageCopier.copy(loadAverage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadAverage(Double ... loadAverage) {
            this.loadAverage(Arrays.asList(loadAverage));
            return this;
        }

        public final void setLoadAverage(Collection<Double> loadAverage) {
            this.loadAverage = LoadAverageCopier.copy(loadAverage);
        }

        @SafeVarargs
        public final void setLoadAverage(Double ... loadAverage) {
            this.loadAverage(Arrays.asList(loadAverage));
        }

        public SystemStatus build() {
            return new SystemStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SystemStatus> {
        public Builder cpuUtilization(CPUUtilization var1);

        public Builder loadAverage(Collection<Double> var1);

        public Builder loadAverage(Double ... var1);
    }
}

