/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionsSpecifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeConfigurationOptionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeConfigurationOptionsRequest> {
    private final String applicationName;
    private final String templateName;
    private final String environmentName;
    private final String solutionStackName;
    private final String platformArn;
    private final List<OptionSpecification> options;

    private DescribeConfigurationOptionsRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.templateName = builder.templateName;
        this.environmentName = builder.environmentName;
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.options = builder.options;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String templateName() {
        return this.templateName;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public String platformArn() {
        return this.platformArn;
    }

    public List<OptionSpecification> options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.templateName() == null ? 0 : this.templateName().hashCode());
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        hashCode = 31 * hashCode + (this.solutionStackName() == null ? 0 : this.solutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.platformArn() == null ? 0 : this.platformArn().hashCode());
        hashCode = 31 * hashCode + (this.options() == null ? 0 : this.options().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationOptionsRequest)) {
            return false;
        }
        DescribeConfigurationOptionsRequest other = (DescribeConfigurationOptionsRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.templateName() == null ^ this.templateName() == null) {
            return false;
        }
        if (other.templateName() != null && !other.templateName().equals(this.templateName())) {
            return false;
        }
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        if (other.environmentName() != null && !other.environmentName().equals(this.environmentName())) {
            return false;
        }
        if (other.solutionStackName() == null ^ this.solutionStackName() == null) {
            return false;
        }
        if (other.solutionStackName() != null && !other.solutionStackName().equals(this.solutionStackName())) {
            return false;
        }
        if (other.platformArn() == null ^ this.platformArn() == null) {
            return false;
        }
        if (other.platformArn() != null && !other.platformArn().equals(this.platformArn())) {
            return false;
        }
        if (other.options() == null ^ this.options() == null) {
            return false;
        }
        return other.options() == null || other.options().equals(this.options());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.templateName() != null) {
            sb.append("TemplateName: ").append(this.templateName()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        if (this.solutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.solutionStackName()).append(",");
        }
        if (this.platformArn() != null) {
            sb.append("PlatformArn: ").append(this.platformArn()).append(",");
        }
        if (this.options() != null) {
            sb.append("Options: ").append(this.options()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String templateName;
        private String environmentName;
        private String solutionStackName;
        private String platformArn;
        private List<OptionSpecification> options;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationOptionsRequest model) {
            this.setApplicationName(model.applicationName);
            this.setTemplateName(model.templateName);
            this.setEnvironmentName(model.environmentName);
            this.setSolutionStackName(model.solutionStackName);
            this.setPlatformArn(model.platformArn);
            this.setOptions(model.options);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        public final Collection<OptionSpecification> getOptions() {
            return this.options;
        }

        @Override
        public final Builder options(Collection<OptionSpecification> options) {
            this.options = OptionsSpecifierListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(OptionSpecification ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        public final void setOptions(Collection<OptionSpecification> options) {
            this.options = OptionsSpecifierListCopier.copy(options);
        }

        @SafeVarargs
        public final void setOptions(OptionSpecification ... options) {
            this.options(Arrays.asList(options));
        }

        public DescribeConfigurationOptionsRequest build() {
            return new DescribeConfigurationOptionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeConfigurationOptionsRequest> {
        public Builder applicationName(String var1);

        public Builder templateName(String var1);

        public Builder environmentName(String var1);

        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder options(Collection<OptionSpecification> var1);

        public Builder options(OptionSpecification ... var1);
    }
}

