/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionDescriptionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeApplicationVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeApplicationVersionsResponse> {
    private final List<ApplicationVersionDescription> applicationVersions;
    private final String nextToken;

    private DescribeApplicationVersionsResponse(BuilderImpl builder) {
        this.applicationVersions = builder.applicationVersions;
        this.nextToken = builder.nextToken;
    }

    public List<ApplicationVersionDescription> applicationVersions() {
        return this.applicationVersions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationVersions() == null ? 0 : this.applicationVersions().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationVersionsResponse)) {
            return false;
        }
        DescribeApplicationVersionsResponse other = (DescribeApplicationVersionsResponse)((Object)obj);
        if (other.applicationVersions() == null ^ this.applicationVersions() == null) {
            return false;
        }
        if (other.applicationVersions() != null && !other.applicationVersions().equals(this.applicationVersions())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationVersions() != null) {
            sb.append("ApplicationVersions: ").append(this.applicationVersions()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ApplicationVersionDescription> applicationVersions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationVersionsResponse model) {
            this.setApplicationVersions(model.applicationVersions);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ApplicationVersionDescription> getApplicationVersions() {
            return this.applicationVersions;
        }

        @Override
        public final Builder applicationVersions(Collection<ApplicationVersionDescription> applicationVersions) {
            this.applicationVersions = ApplicationVersionDescriptionListCopier.copy(applicationVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationVersions(ApplicationVersionDescription ... applicationVersions) {
            this.applicationVersions(Arrays.asList(applicationVersions));
            return this;
        }

        public final void setApplicationVersions(Collection<ApplicationVersionDescription> applicationVersions) {
            this.applicationVersions = ApplicationVersionDescriptionListCopier.copy(applicationVersions);
        }

        @SafeVarargs
        public final void setApplicationVersions(ApplicationVersionDescription ... applicationVersions) {
            this.applicationVersions(Arrays.asList(applicationVersions));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeApplicationVersionsResponse build() {
            return new DescribeApplicationVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeApplicationVersionsResponse> {
        public Builder applicationVersions(Collection<ApplicationVersionDescription> var1);

        public Builder applicationVersions(ApplicationVersionDescription ... var1);

        public Builder nextToken(String var1);
    }
}

