/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteEnvironmentConfigurationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteEnvironmentConfigurationRequest> {
    private final String applicationName;
    private final String environmentName;

    private DeleteEnvironmentConfigurationRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.environmentName = builder.environmentName;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String environmentName() {
        return this.environmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.environmentName() == null ? 0 : this.environmentName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEnvironmentConfigurationRequest)) {
            return false;
        }
        DeleteEnvironmentConfigurationRequest other = (DeleteEnvironmentConfigurationRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.environmentName() == null ^ this.environmentName() == null) {
            return false;
        }
        return other.environmentName() == null || other.environmentName().equals(this.environmentName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.environmentName() != null) {
            sb.append("EnvironmentName: ").append(this.environmentName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String environmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEnvironmentConfigurationRequest model) {
            this.setApplicationName(model.applicationName);
            this.setEnvironmentName(model.environmentName);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public DeleteEnvironmentConfigurationRequest build() {
            return new DeleteEnvironmentConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteEnvironmentConfigurationRequest> {
        public Builder applicationName(String var1);

        public Builder environmentName(String var1);
    }
}

