/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest;

public class ValidateConfigurationSettingsRequestMarshaller
implements Marshaller<Request<ValidateConfigurationSettingsRequest>, ValidateConfigurationSettingsRequest> {
    public Request<ValidateConfigurationSettingsRequest> marshall(ValidateConfigurationSettingsRequest validateConfigurationSettingsRequest) {
        if (validateConfigurationSettingsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)validateConfigurationSettingsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "ValidateConfigurationSettings");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (validateConfigurationSettingsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)validateConfigurationSettingsRequest.applicationName()));
        }
        if (validateConfigurationSettingsRequest.templateName() != null) {
            request.addParameter("TemplateName", StringConversion.fromString((String)validateConfigurationSettingsRequest.templateName()));
        }
        if (validateConfigurationSettingsRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)validateConfigurationSettingsRequest.environmentName()));
        }
        if (validateConfigurationSettingsRequest.optionSettings().isEmpty() && !(validateConfigurationSettingsRequest.optionSettings() instanceof SdkAutoConstructList)) {
            request.addParameter("OptionSettings", "");
        } else if (!validateConfigurationSettingsRequest.optionSettings().isEmpty() && !(validateConfigurationSettingsRequest.optionSettings() instanceof SdkAutoConstructList)) {
            List<ConfigurationOptionSetting> optionSettingsList = validateConfigurationSettingsRequest.optionSettings();
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue.resourceName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringConversion.fromString((String)optionSettingsListValue.resourceName()));
                }
                if (optionSettingsListValue.namespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringConversion.fromString((String)optionSettingsListValue.namespace()));
                }
                if (optionSettingsListValue.optionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringConversion.fromString((String)optionSettingsListValue.optionName()));
                }
                if (optionSettingsListValue.value() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringConversion.fromString((String)optionSettingsListValue.value()));
                }
                ++optionSettingsListIndex;
            }
        }
        return request;
    }
}

