/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.MaxAgeRule;
import software.amazon.awssdk.services.elasticbeanstalk.model.MaxCountRule;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest;

public class UpdateApplicationResourceLifecycleRequestMarshaller
implements Marshaller<Request<UpdateApplicationResourceLifecycleRequest>, UpdateApplicationResourceLifecycleRequest> {
    public Request<UpdateApplicationResourceLifecycleRequest> marshall(UpdateApplicationResourceLifecycleRequest updateApplicationResourceLifecycleRequest) {
        ApplicationResourceLifecycleConfig resourceLifecycleConfig;
        if (updateApplicationResourceLifecycleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateApplicationResourceLifecycleRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "UpdateApplicationResourceLifecycle");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateApplicationResourceLifecycleRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)updateApplicationResourceLifecycleRequest.applicationName()));
        }
        if ((resourceLifecycleConfig = updateApplicationResourceLifecycleRequest.resourceLifecycleConfig()) != null) {
            ApplicationVersionLifecycleConfig versionLifecycleConfig;
            if (resourceLifecycleConfig.serviceRole() != null) {
                request.addParameter("ResourceLifecycleConfig.ServiceRole", StringConversion.fromString((String)resourceLifecycleConfig.serviceRole()));
            }
            if ((versionLifecycleConfig = resourceLifecycleConfig.versionLifecycleConfig()) != null) {
                MaxAgeRule maxAgeRule;
                MaxCountRule maxCountRule = versionLifecycleConfig.maxCountRule();
                if (maxCountRule != null) {
                    if (maxCountRule.enabled() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxCountRule.Enabled", StringConversion.fromBoolean((Boolean)maxCountRule.enabled()));
                    }
                    if (maxCountRule.maxCount() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxCountRule.MaxCount", StringConversion.fromInteger((Integer)maxCountRule.maxCount()));
                    }
                    if (maxCountRule.deleteSourceFromS3() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxCountRule.DeleteSourceFromS3", StringConversion.fromBoolean((Boolean)maxCountRule.deleteSourceFromS3()));
                    }
                }
                if ((maxAgeRule = versionLifecycleConfig.maxAgeRule()) != null) {
                    if (maxAgeRule.enabled() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxAgeRule.Enabled", StringConversion.fromBoolean((Boolean)maxAgeRule.enabled()));
                    }
                    if (maxAgeRule.maxAgeInDays() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxAgeRule.MaxAgeInDays", StringConversion.fromInteger((Integer)maxAgeRule.maxAgeInDays()));
                    }
                    if (maxAgeRule.deleteSourceFromS3() != null) {
                        request.addParameter("ResourceLifecycleConfig.VersionLifecycleConfig.MaxAgeRule.DeleteSourceFromS3", StringConversion.fromBoolean((Boolean)maxAgeRule.deleteSourceFromS3()));
                    }
                }
            }
        }
        return request;
    }
}

