/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.ResourceQuotas;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ResourceQuotaUnmarshaller;

public class ResourceQuotasUnmarshaller
implements Unmarshaller<ResourceQuotas, StaxUnmarshallerContext> {
    private static final ResourceQuotasUnmarshaller INSTANCE = new ResourceQuotasUnmarshaller();

    public ResourceQuotas unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ResourceQuotas.Builder resourceQuotas = ResourceQuotas.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ApplicationQuota", targetDepth)) {
                    resourceQuotas.applicationQuota(ResourceQuotaUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ApplicationVersionQuota", targetDepth)) {
                    resourceQuotas.applicationVersionQuota(ResourceQuotaUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EnvironmentQuota", targetDepth)) {
                    resourceQuotas.environmentQuota(ResourceQuotaUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ConfigurationTemplateQuota", targetDepth)) {
                    resourceQuotas.configurationTemplateQuota(ResourceQuotaUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CustomPlatformQuota", targetDepth)) continue;
                resourceQuotas.customPlatformQuota(ResourceQuotaUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ResourceQuotas)resourceQuotas.build();
    }

    public static ResourceQuotasUnmarshaller getInstance() {
        return INSTANCE;
    }
}

