/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest;

public class RequestEnvironmentInfoRequestMarshaller
implements Marshaller<Request<RequestEnvironmentInfoRequest>, RequestEnvironmentInfoRequest> {
    public Request<RequestEnvironmentInfoRequest> marshall(RequestEnvironmentInfoRequest requestEnvironmentInfoRequest) {
        if (requestEnvironmentInfoRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)requestEnvironmentInfoRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "RequestEnvironmentInfo");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (requestEnvironmentInfoRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringConversion.fromString((String)requestEnvironmentInfoRequest.environmentId()));
        }
        if (requestEnvironmentInfoRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)requestEnvironmentInfoRequest.environmentName()));
        }
        if (requestEnvironmentInfoRequest.infoTypeAsString() != null) {
            request.addParameter("InfoType", StringConversion.fromString((String)requestEnvironmentInfoRequest.infoTypeAsString()));
        }
        return request;
    }
}

